/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.codestation.client.ant;

import com.urbancode.ubuild.codestation.client.BuildProcess;
import com.urbancode.ubuild.codestation.client.BuildProcessLookup;
import com.urbancode.ubuild.codestation.client.CodestationClient;
import com.urbancode.ubuild.codestation.client.ant.CodestationTask;
import java.io.File;
import org.apache.tools.ant.BuildException;

public class PublishTask
extends CodestationTask {
    private String projectId;
    private String processId;
    private String setName = null;
    private boolean publishAll;

    public void execute() throws BuildException {
        long start = System.currentTimeMillis();
        this.printVersionInfo();
        if (this.projectId == null) {
            throw new BuildException("Project is required");
        }
        if (this.processId == null) {
            throw new BuildException("Process is required");
        }
        try {
            CodestationClient client = this.configureBaseClient();
            File srcDir = new File(this.basedir);
            BuildProcessLookup processLookup = client.getBuildProcessLookup();
            BuildProcess process = processLookup.findBuildProcess(this.projectId, this.processId);
            if (this.publishAll) {
                this.log("publish All artifactSets");
                client.publishArtifacts(process, srcDir.getAbsolutePath(), null);
            } else if (this.setName != null) {
                this.log("publish artifactSet '" + this.setName + "'");
                client.publishArtifacts(process, srcDir.getAbsolutePath(), this.setName);
            } else {
                this.log("artifactSet or publishAll has to be set.");
            }
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            String message = "Error resolving dependency artifacts: " + this.getRootExceptionMessage(e);
            throw new BuildException(message, (Throwable)e);
        }
        long duration = System.currentTimeMillis() - start;
        this.log("Task finished in " + duration + " ms");
    }

    public void setProject(String aString) {
        this.projectId = aString;
    }

    public void setProcess(String aString) {
        this.processId = aString;
    }

    public void setSetName(String setName) {
        this.setName = setName;
    }

    public void setPublishAll(boolean publishall) {
        this.publishAll = publishall;
    }
}

