/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.codestation.client.util.error;

public final class ErrorCode {
    public static final String GENERAL_FAILURE = "GeneralFailure";
    public static final String SERVER_ERROR = "ServerError";
    public static final String INVALID_CREDENTIALS = ErrorCode.inherit("InvalidCredentials", "ServerError");
    public static final String PROJECT_INFO_NOT_FOUND = ErrorCode.inherit("ProjectInfoNotFound", "ServerError");
    public static final String BUILD_LIFE_NOT_FOUND = ErrorCode.inherit("BuildLifeNotFound", "ServerError");
    public static final String INVALID_PARAMETERS = ErrorCode.inherit("InvalidParameters", "ServerError");
    public static final String SERVER_FAILED = ErrorCode.inherit("InternalServerError", "ServerError");
    public static final String ARTIFACTS_NOT_FOUND = ErrorCode.inherit("ArtifactsNotFound", "ServerError");
    public static final String REJECTED_PROTOCOL = ErrorCode.inherit("RejectedProtocolVersion", "ServerError");
    public static final String CLIENT_ERROR = "ClientError";
    public static final String INVALID_URL = ErrorCode.inherit("InvalidUrl", "ClientError");
    public static final String BAD_CREDENTIAL_CRYPTO = ErrorCode.inherit("InvalidCredentialCrypto", "ClientError");
    public static final String FILE_VERIFY_FAILED = ErrorCode.inherit("FileVerificationFailed", "ClientError");
    public static final String PROJECT_INFO_NOT_CACHED = ErrorCode.inherit("ProjectInfoNotCached", "ClientError");
    public static final String FORBIDDEN_BY_PROXY = ErrorCode.inherit("ForbiddenByProxy", "ClientError");
    public static final String SERVER_NOT_FOUND = ErrorCode.inherit("ServerNotFound", "ClientError");
    public static final String NO_CREDENTIALS = ErrorCode.inherit("NoCredentials", "ClientError");
    public static final String DEPENDENCY_CONFIG_NOT_FOUND = ErrorCode.inherit("DependencyConfigNotFound", "ClientError");
    public static final String INVALID_COMMAND_LINE = ErrorCode.inherit("InvalidCommandLine", "ClientError");
    public static final String NO_SUCH_COMMAND = ErrorCode.inherit("NoSuchCommand", INVALID_COMMAND_LINE);
    public static final String INVALID_XML_COMMAND = ErrorCode.inherit("InvalidXmlCommand", INVALID_COMMAND_LINE);
    public static final String TOO_MANY_COMMANDS = ErrorCode.inherit("TooManyCommands", INVALID_COMMAND_LINE);
    public static final String INVALID_OPTIONS = ErrorCode.inherit("InvalidOptions", INVALID_COMMAND_LINE);

    private static String inherit(String name, String parent) {
        return name + ":" + parent;
    }

    private ErrorCode() {
    }
}

