/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.vfs.client.cache;

import com.urbancode.commons.util.IO;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class CacheStagingFileOutputStream
extends OutputStream {
    private final Object closeLock = new Object();
    private final OutputStream delegate;
    private boolean closed;

    CacheStagingFileOutputStream(File file) throws IOException {
        IO.mkdirs((File)file.getParentFile());
        this.delegate = new FileOutputStream(file);
    }

    public void write(int b) throws IOException {
        this.delegate.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.delegate.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.delegate.write(b, off, len);
    }

    public void flush() throws IOException {
        this.delegate.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (!this.closed) {
                this.closed = true;
                this.delegate.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.closeLock;
        synchronized (object) {
            return this.closed;
        }
    }
}

