/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.fileutils.filelister;

import com.urbancode.commons.fileutils.filelister.FileListerBase;
import com.urbancode.commons.fileutils.filelister.FileListerFactory;
import com.urbancode.commons.fileutils.filelister.FileType;
import com.urbancode.commons.fileutils.filelister.PermissionReader;
import com.urbancode.commons.fileutils.filelister.TypedFile;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;

final class FileListerIncludeNonEmptyAsLink
extends FileListerBase {
    static final FileListerFactory FACTORY = new FileListerFactory(){

        public FileListerIncludeNonEmptyAsLink create(File base, FileFilter filter, PermissionReader permissionReader) throws IOException {
            return new FileListerIncludeNonEmptyAsLink(base, filter, permissionReader);
        }

        public String implementationName() {
            return FileListerIncludeNonEmptyAsLink.class.getName();
        }
    };

    FileListerIncludeNonEmptyAsLink(File base, FileFilter filter, PermissionReader permissionReader) throws IOException {
        super(base, filter, permissionReader);
    }

    protected boolean includeInList(TypedFile file) {
        if (file.type() != FileType.DIRECTORY) {
            return true;
        }
        String[] files = file.translate(this.base()).list();
        return files != null && files.length > 0;
    }

    protected TypedFile normalize(TypedFile file) {
        return file;
    }

    boolean isSymLinkAware() {
        return true;
    }
}

