/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.codestation.client;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class ArtifactDeliverPattern {
    private final String artifactSet;
    private final String baseDirectory;
    private final String[] includes;
    private final String[] excludes;

    ArtifactDeliverPattern(String artifactSet, String baseDirectory, String[] includes, String[] excludes) {
        this.artifactSet = artifactSet;
        this.baseDirectory = StringUtils.isEmpty((String)baseDirectory) ? "." : baseDirectory;
        this.includes = this.filterPaths(includes, true);
        this.excludes = this.filterPaths(excludes, false);
    }

    public String getArtifactSet() {
        return this.artifactSet;
    }

    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    public String[] getIncludes() {
        return (String[])this.includes.clone();
    }

    public String[] getExcludes() {
        return (String[])this.excludes.clone();
    }

    private String[] filterPaths(String[] paths, boolean returnAllIfNull) {
        ArrayList<String> filteredPaths = new ArrayList<String>();
        if (paths == null) {
            if (returnAllIfNull) {
                filteredPaths.add("**/*");
            }
        } else {
            for (String path : paths) {
                if (StringUtils.isBlank((String)path)) continue;
                filteredPaths.add(path);
            }
        }
        return filteredPaths.toArray(new String[0]);
    }
}

