/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.vfs.client;

import com.urbancode.commons.util.IO;
import com.urbancode.vfs.common.Hash;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collections;
import org.apache.http.entity.FileEntity;

public class HashingInputStreamRequestEntity
extends FileEntity {
    protected final MessageDigest digest;
    protected final long length;

    HashingInputStreamRequestEntity(File file, long length, MessageDigest digest) {
        super(file);
        this.digest = digest;
        this.length = length;
        this.setContentType("application/octet-stream");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream output) throws IOException {
        FileInputStream iStream = new FileInputStream(this.file);
        try {
            DataOutputStream dataOutput = new DataOutputStream(new BufferedOutputStream(output, 65536));
            dataOutput.writeLong(this.length);
            this.digest.reset();
            IO.copyAndDigest((InputStream)iStream, (OutputStream)dataOutput, (long)this.length, (MessageDigest[])new MessageDigest[]{this.digest});
            String hash = Hash.hashForMessageDigest(this.digest).toString();
            dataOutput.writeUTF(hash);
            dataOutput.flush();
        }
        finally {
            ((InputStream)iStream).close();
        }
    }

    private InputStream concat(InputStream ... args) {
        return new SequenceInputStream(Collections.enumeration(Arrays.asList(args)));
    }

    public InputStream getContent() throws IOException {
        ByteArrayOutputStream lengthBAOS = new ByteArrayOutputStream();
        DataOutputStream lengthDOS = new DataOutputStream(lengthBAOS);
        lengthDOS.writeLong(this.length);
        ByteArrayInputStream lengthBAIS = new ByteArrayInputStream(lengthBAOS.toByteArray());
        FileInputStream fileInput = new FileInputStream(this.file);
        this.digest.reset();
        IO.digest((File)this.file, (MessageDigest)this.digest);
        String hash = Hash.hashForMessageDigest(this.digest).toString();
        ByteArrayOutputStream hashBAOS = new ByteArrayOutputStream();
        DataOutputStream hashDOS = new DataOutputStream(hashBAOS);
        hashDOS.writeUTF(hash);
        ByteArrayInputStream hashBAIS = new ByteArrayInputStream(hashBAOS.toByteArray());
        return this.concat(lengthBAIS, fileInput, hashBAIS);
    }

    public long getContentLength() {
        return -1L;
    }
}

