/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.codestation.client;

import com.urbancode.commons.fileutils.filelister.FileListerBuilder;
import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder;
import com.urbancode.commons.util.StringUtil;
import com.urbancode.ubuild.codestation.client.ArtifactDeliverPattern;
import com.urbancode.ubuild.codestation.client.ArtifactDownloadException;
import com.urbancode.ubuild.codestation.client.ArtifactDownloader;
import com.urbancode.ubuild.codestation.client.ArtifactSetNotFoundException;
import com.urbancode.ubuild.codestation.client.ArtifactUploadException;
import com.urbancode.ubuild.codestation.client.ArtifactUploader;
import com.urbancode.ubuild.codestation.client.AuthenticationCredentials;
import com.urbancode.ubuild.codestation.client.BuildLife;
import com.urbancode.ubuild.codestation.client.BuildLifeLookup;
import com.urbancode.ubuild.codestation.client.BuildProcess;
import com.urbancode.ubuild.codestation.client.BuildProcessLookup;
import com.urbancode.ubuild.codestation.client.DependenciesLookup;
import com.urbancode.ubuild.codestation.client.LocalRepository;
import com.urbancode.ubuild.codestation.client.UrlMaker;
import com.urbancode.ubuild.codestation.client.util.CodestationProperties;
import com.urbancode.ubuild.codestation.xml.Dependencies;
import com.urbancode.ubuild.codestation.xml.Dependency;
import com.urbancode.ubuild.codestation.xml.DependencyDelivery;
import com.urbancode.vfs.client.Client;
import com.urbancode.vfs.client.cache.Cache;
import com.urbancode.vfs.common.ClientChangeSet;
import com.urbancode.vfs.common.ClientPathEntry;
import com.urbancode.vfs.common.ClientRepository;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodestationClient {
    private static final Logger log = Logger.getLogger(CodestationClient.class);
    private static final int RETRY_COUNT = 5;
    private final String url;
    private final AuthenticationCredentials credentials;
    private final Client vfsClient;
    private final DefaultHttpClient httpClient;
    private FileListerBuilder.Directories directories = FileListerBuilder.Directories.INCLUDE_ALL;
    private FileListerBuilder.Permissions permissions = FileListerBuilder.Permissions.NONE;
    private FileListerBuilder.Symlinks symlinks = FileListerBuilder.Symlinks.AS_LINK;
    private String hashAlgorithm = "SHA-256";
    private List<String> additionalDigestAlgorithms = new ArrayList<String>();
    private CodestationProperties codestationProperties;
    private boolean failIfNotFound = false;
    private LocalRepository repo = null;
    private int requestTimeout = -1;

    public CodestationClient(String url, AuthenticationCredentials authCredentials) {
        HttpClientBuilder clientBuilder = new HttpClientBuilder();
        clientBuilder.setTrustAllCerts(true);
        this.codestationProperties = new CodestationProperties();
        Properties properties = new Properties();
        if (StringUtils.isNotBlank((CharSequence)url)) {
            properties.put("codestation.server", url);
        }
        if (authCredentials != null) {
            if (authCredentials.getUsername() != null) {
                properties.put("codestation.user", authCredentials.getUsername());
                properties.put("codestation.password", authCredentials.getPassword());
            } else if (authCredentials.getAuthToken() != null) {
                properties.put("codestation.authToken", authCredentials.getAuthToken());
            }
        }
        this.codestationProperties.configure(properties);
        this.credentials = this.codestationProperties.getCredentials();
        this.url = new UrlMaker().makeCodestationBaseUrl(this.codestationProperties.getServer());
        String proxyHost = System.getProperty("http.proxyHost");
        if (!StringUtil.isEmpty((String)proxyHost)) {
            Integer proxyPort = Integer.valueOf(System.getProperty("http.proxyPort"));
            clientBuilder.setProxyHost(proxyHost);
            clientBuilder.setProxyPort(proxyPort.intValue());
            this.vfsClient = new Client(this.url, proxyHost, proxyPort);
        } else {
            this.vfsClient = new Client(this.url);
        }
        if (this.credentials != null) {
            if (!StringUtil.isEmpty((String)this.credentials.getAuthToken())) {
                this.vfsClient.setRequestHeader("Authorization-Token", this.credentials.getAuthToken());
            }
            if (!StringUtil.isEmpty((String)this.credentials.getUsername()) && !StringUtil.isEmpty((String)this.credentials.getPassword())) {
                this.vfsClient.setBasicAuthCredentials(this.credentials.getUsername(), this.credentials.getPassword());
            }
        }
        this.httpClient = clientBuilder.buildClient();
        String userHome = System.getProperty("user.home");
        File csHomeDir = new File(userHome, ".codestation");
        File defaultRepoDir = new File(csHomeDir, "repo");
        this.repo = new LocalRepository(defaultRepoDir, null);
    }

    public void addAdditionalDigestAlgorithm(String digestAlgorithm) {
        if (!"SHA-256".equalsIgnoreCase(digestAlgorithm)) {
            this.additionalDigestAlgorithms.add(digestAlgorithm);
        }
    }

    public List<String> getAdditionalDigestAlgorithms() {
        return new ArrayList<String>(this.additionalDigestAlgorithms);
    }

    public BuildProcessLookup getBuildProcessLookup() {
        return new BuildProcessLookup(this);
    }

    public BuildLifeLookup getBuildLifeLookup() {
        return new BuildLifeLookup(this);
    }

    public List<File> downloadDependencies(BuildLife buildLife, File destination) throws ArtifactDownloadException {
        DependenciesLookup lookup = new DependenciesLookup(this);
        Dependencies dependencies = null;
        try {
            dependencies = lookup.findDependencies(buildLife);
        }
        catch (Exception e) {
            String eMsg = (String)StringUtils.defaultIfBlank((CharSequence)e.getMessage(), (CharSequence)"Error downloading build life's dependencies");
            throw new ArtifactDownloadException(eMsg, e);
        }
        return this.downloadDependencies(dependencies, destination);
    }

    public List<File> downloadDependencies(BuildLife buildLife, File dependenciesXml, File destination) throws ArtifactDownloadException {
        DependenciesLookup lookup = new DependenciesLookup(this);
        Dependencies dependencies = null;
        try {
            dependencies = lookup.findDependencies(buildLife, dependenciesXml);
        }
        catch (Exception e) {
            String eMsg = (String)StringUtils.defaultIfBlank((CharSequence)e.getMessage(), (CharSequence)"Error downloading build life's dependencies");
            throw new ArtifactDownloadException(eMsg, e);
        }
        return this.downloadDependencies(dependencies, destination);
    }

    public List<File> downloadDependencies(BuildProcess process, File dependenciesXml, File destination) throws ArtifactDownloadException {
        DependenciesLookup lookup = new DependenciesLookup(this);
        Dependencies dependencies = null;
        try {
            dependencies = lookup.findDependencies(process, dependenciesXml);
        }
        catch (Exception e) {
            String eMsg = (String)StringUtils.defaultIfBlank((CharSequence)e.getMessage(), (CharSequence)"Error downloading build life's dependencies");
            throw new ArtifactDownloadException(eMsg, e);
        }
        return this.downloadDependencies(dependencies, destination);
    }

    public List<File> downloadDependencies(BuildProcess config, File destination) throws ArtifactDownloadException {
        DependenciesLookup lookup = new DependenciesLookup(this);
        Dependencies dependencies = null;
        try {
            dependencies = lookup.findDependencies(config);
        }
        catch (Exception e) {
            String eMsg = (String)StringUtils.defaultIfBlank((CharSequence)e.getMessage(), (CharSequence)"Error determining dependencies");
            throw new ArtifactDownloadException(eMsg, e);
        }
        return this.downloadDependencies(dependencies, destination);
    }

    public List<File> downloadArtifacts(BuildLife buildLife, String artifactSet, File ... destinations) throws ArtifactDownloadException {
        String repoId = buildLife.getRepositoryId();
        ArtifactDownloader downloader = new ArtifactDownloader(this.vfsClient);
        return downloader.downloadArtifacts(repoId, artifactSet, null, null, destinations);
    }

    private List<File> downloadDependencies(Dependencies dependencies, File destination) throws ArtifactDownloadException {
        ArrayList<File> downloadedFiles = new ArrayList<File>();
        for (Dependency dependency : dependencies.getDependency()) {
            BuildLife depBuildLife = BuildLife.fromDependency(this, dependency);
            for (DependencyDelivery delivery : dependency.getDelivery()) {
                String artifactSet = delivery.getArtifactSet();
                for (String directory : delivery.getDirectory()) {
                    File downloadDir = new File(destination, directory);
                    downloadedFiles.addAll(this.downloadArtifacts(depBuildLife, artifactSet, downloadDir));
                }
            }
        }
        return downloadedFiles;
    }

    public void setCacheDir(File cacheDir) throws IOException {
        this.vfsClient.setCache(new Cache(cacheDir));
    }

    public void setSymlinks(FileListerBuilder.Symlinks symlinks) {
        this.symlinks = symlinks;
    }

    public void setDirectories(FileListerBuilder.Directories directories) {
        this.directories = directories;
    }

    public void setPermissions(FileListerBuilder.Permissions permissions) {
        this.permissions = permissions;
    }

    public void setFailIfNotFound(boolean failIfNotFound) {
        this.failIfNotFound = failIfNotFound;
    }

    private void setRequestTimeout(Integer requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public void uploadArtifactSet(BuildLife buildLife, String artifactSet, File baseDirectory, FileListerBuilder.Symlinks symlinks, FileListerBuilder.Directories directories, FileListerBuilder.Permissions permissions) throws ArtifactUploadException, ArtifactSetNotFoundException {
        this.uploadArtifactSet(buildLife, artifactSet, baseDirectory, symlinks, directories, permissions, -1);
    }

    public void uploadArtifactSet(BuildLife buildLife, String artifactSet, File baseDirectory, FileListerBuilder.Symlinks symlinks, FileListerBuilder.Directories directories, FileListerBuilder.Permissions permissions, int requestTimeout) throws ArtifactUploadException, ArtifactSetNotFoundException {
        this.setSymlinks(symlinks);
        this.setDirectories(directories);
        this.setPermissions(permissions);
        this.setRequestTimeout(requestTimeout);
        this.uploadArtifactSet(buildLife, artifactSet, baseDirectory);
    }

    public void uploadArtifactSet(BuildLife buildLife, String artifactSet, File baseDirectory) throws ArtifactUploadException, ArtifactSetNotFoundException {
        BuildProcess process;
        try {
            process = buildLife.lookupBuildProcess();
        }
        catch (Exception e) {
            throw new ArtifactUploadException("Error loading the build configuration for the build life.", e);
        }
        boolean artifactSetFound = false;
        for (ArtifactDeliverPattern artifactDeliver : process.getArtifactDeliverPatterns()) {
            if (!StringUtil.isEmpty((String)artifactSet) && !artifactSet.equals(artifactDeliver.getArtifactSet())) continue;
            artifactSetFound = true;
            this.uploadArtifacts(buildLife, artifactDeliver, baseDirectory);
        }
        if (!artifactSetFound) {
            throw new ArtifactSetNotFoundException("No artifact delivery configuration for artifact set '" + artifactSet + "' was found.");
        }
    }

    public void uploadAllArtifacts(BuildLife buildLife, File baseDirectory, FileListerBuilder.Symlinks symlinks, FileListerBuilder.Directories directories, FileListerBuilder.Permissions permissions) throws ArtifactUploadException, ArtifactSetNotFoundException {
        this.uploadAllArtifacts(buildLife, baseDirectory, symlinks, directories, permissions, -1);
    }

    public void uploadAllArtifacts(BuildLife buildLife, File baseDirectory, FileListerBuilder.Symlinks symlinks, FileListerBuilder.Directories directories, FileListerBuilder.Permissions permissions, int requestTimeout) throws ArtifactUploadException, ArtifactSetNotFoundException {
        this.setSymlinks(symlinks);
        this.setDirectories(directories);
        this.setRequestTimeout(requestTimeout);
        this.setPermissions(permissions);
        this.uploadAllArtifacts(buildLife, baseDirectory);
    }

    public void uploadAllArtifacts(BuildLife buildLife, File baseDirectory) throws ArtifactUploadException, ArtifactSetNotFoundException {
        BuildProcess process;
        try {
            process = buildLife.lookupBuildProcess();
        }
        catch (Exception e) {
            throw new ArtifactUploadException("Error loading the build configuration for the build life.", e);
        }
        for (ArtifactDeliverPattern artifactDeliver : process.getArtifactDeliverPatterns()) {
            this.uploadArtifacts(buildLife, artifactDeliver, baseDirectory);
        }
    }

    private void uploadArtifacts(BuildLife buildLife, ArtifactDeliverPattern artifactDeliver, File baseDirectory) throws ArtifactUploadException {
        String repoId = buildLife.getRepositoryId();
        ArtifactUploader uploader = new ArtifactUploader(this.vfsClient);
        uploader.setFailIfNotFound(this.failIfNotFound);
        File artifactDeliverDirectory = new File(baseDirectory, artifactDeliver.getBaseDirectory());
        uploader.uploadArtifacts(repoId, artifactDeliver.getArtifactSet(), artifactDeliverDirectory, artifactDeliver.getIncludes(), artifactDeliver.getExcludes(), this.directories, this.permissions, this.symlinks, this.hashAlgorithm, this.getAdditionalDigestAlgorithms(), this.requestTimeout);
    }

    public void publishArtifacts(BuildProcess process, String artifactSrcDir, String setName) throws Exception {
        String processId = process.getProcessId();
        String projectId = process.getProjectId();
        boolean found = false;
        System.out.println("Publishing artifacts for processId '" + processId + "' to local repository");
        long start = System.currentTimeMillis();
        if (setName != null) {
            for (ArtifactDeliverPattern artifactDeliver : process.getArtifactDeliverPatterns()) {
                if (!setName.equals(artifactDeliver.getArtifactSet())) continue;
                found = true;
                this.publish(process, artifactSrcDir, artifactDeliver);
            }
            if (!found) {
                throw new IOException("Did not find an artifactSet with name '" + setName + "' in project '" + projectId + "'");
            }
        } else {
            for (ArtifactDeliverPattern artifactDeliver : process.getArtifactDeliverPatterns()) {
                setName = artifactDeliver.getArtifactSet();
                found = true;
                this.publish(process, artifactSrcDir, artifactDeliver);
            }
            if (!found) {
                throw new IOException("Did not find any artifactSet in project '" + projectId + "'");
            }
        }
        long duration = System.currentTimeMillis() - start;
        System.out.println("Publish finished in " + duration + " ms");
    }

    private void publish(BuildProcess process, String artifactSrcDir, ArtifactDeliverPattern artifactDeliver) {
        String setName = artifactDeliver.getArtifactSet();
        try {
            this.repo.cleanArtifactSet(process, setName);
            File baseFile = new File(artifactSrcDir);
            System.out.println("Publishing '" + setName + "' from " + baseFile.getAbsolutePath());
            this.repo.addArtifactSet(baseFile, artifactDeliver, process);
            System.out.println("Successfully published '" + setName + "'");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void copyAllArtifacts(BuildLife buildLife, String targetUrl, String repositoryId, String username, String password, Map<String, String> requestHeaders, String label) throws ArtifactUploadException {
        int numberOfTries = 0;
        int retriesLeft = 0;
        boolean successful = false;
        while (numberOfTries < 5 && !successful) {
            try {
                retriesLeft = 5 - ++numberOfTries;
                this.vfsClient.copyChangeSet(buildLife.getRepositoryId(), "latest", targetUrl, repositoryId, username, password, requestHeaders, label);
                successful = true;
            }
            catch (Exception e) {
                String message;
                String detailedInformation = "buildlife id='" + buildLife.getId() + "', repositoryId='" + repositoryId + "', label='" + label + "', targetUrl='" + targetUrl + "'";
                if (numberOfTries >= 5) {
                    throw new ArtifactUploadException("Giving up artifact sets upload  after 5 attempts: " + detailedInformation, e);
                }
                if (e instanceof NoHttpResponseException) {
                    message = "No http response to upload request: " + detailedInformation + ", retrying up to " + retriesLeft + " more times";
                    log.warn((Object)message, (Throwable)e);
                    continue;
                }
                if (this.exceptionContainsString(e, "Connection Reset")) {
                    message = "Connection Reset during upload: " + detailedInformation + ", retrying up to " + retriesLeft + " more times";
                    log.warn((Object)message, (Throwable)e);
                    continue;
                }
                if (this.exceptionContainsString(e, "Broken Pipe")) {
                    message = "Broken pipe during upload: " + detailedInformation + ", retrying up to " + retriesLeft + " more times";
                    log.warn((Object)message, (Throwable)e);
                    continue;
                }
                if (this.exceptionContainsString(e, "write error")) {
                    message = "Write error during upload: " + detailedInformation + ", retrying up to " + retriesLeft + " more times";
                    log.warn((Object)message, (Throwable)e);
                    continue;
                }
                throw new ArtifactUploadException("Error copying artifact sets: " + detailedInformation, e);
            }
        }
    }

    public void copyAllArtifactsToUrbanCodeDeploy(BuildLife buildLife, String targetUrl, String component, String username, String password, Map<String, String> requestHeaders, String version) throws ArtifactUploadException {
        int numberOfTries = 0;
        int retriesLeft = 0;
        boolean successful = false;
        while (numberOfTries < 5 && !successful) {
            try {
                retriesLeft = 5 - ++numberOfTries;
                this.vfsClient.copyChangeSetToUrbanCodeDeploy(buildLife.getRepositoryId(), "latest", targetUrl, component, username, password, requestHeaders, version);
                successful = true;
            }
            catch (Exception e) {
                String message;
                String detailedInformation = "buildlife id='" + buildLife.getId() + "', component version='" + version + "', component='" + component + "', targetUrl='" + targetUrl + "'";
                if (numberOfTries >= 5) {
                    throw new ArtifactUploadException("Giving up artifact sets upload after 5 attempts: " + detailedInformation, e);
                }
                if (e instanceof NoHttpResponseException) {
                    message = "No http response to upload request: " + detailedInformation + ", retrying up to " + retriesLeft + " more times";
                    log.warn((Object)message, (Throwable)e);
                    continue;
                }
                if (this.exceptionContainsString(e, "Connection Reset")) {
                    message = "Connection Reset during upload: " + detailedInformation + ", retrying up to " + retriesLeft + " more times";
                    log.warn((Object)message, (Throwable)e);
                    continue;
                }
                if (this.exceptionContainsString(e, "Broken Pipe")) {
                    message = "Broken pipe during upload: " + detailedInformation + ", retrying up to " + retriesLeft + " more times";
                    log.warn((Object)message, (Throwable)e);
                    continue;
                }
                if (this.exceptionContainsString(e, "write error")) {
                    message = "Write error during upload: " + detailedInformation + ", retrying up to " + retriesLeft + " more times";
                    log.warn((Object)message, (Throwable)e);
                    continue;
                }
                throw new ArtifactUploadException("Error copying artifact sets: " + detailedInformation, e);
            }
        }
    }

    public void setExecuteBitsOnly(boolean setExecuteBitsOnly) {
        this.vfsClient.setSetFileExecuteBitsOnly(setExecuteBitsOnly);
    }

    public void setSetPermissions(boolean setPermissions) {
        this.vfsClient.setSetPermissions(setPermissions);
    }

    public List<String> getPublishedArtifactSets(String buildLifeId) throws Exception {
        BuildLife buildLife = this.getBuildLifeLookup().findBuildLife(buildLifeId);
        ArrayList<String> setList = new ArrayList<String>();
        String repositoryId = buildLife.getRepositoryId();
        ClientRepository repository = this.vfsClient.getRepository(repositoryId);
        if (repository != null) {
            HashSet<String> artifactSetSet = new HashSet<String>();
            String changeSetId = repository.getLatestChangeSet();
            ClientChangeSet changeSet = this.vfsClient.getChangeSet(repositoryId, changeSetId);
            if (changeSet != null) {
                for (ClientPathEntry entry : changeSet.getEntries()) {
                    int sepIndex = entry.getPath().indexOf("/");
                    if (sepIndex <= 0) continue;
                    String artifactSet = entry.getPath().substring(0, sepIndex);
                    artifactSetSet.add(artifactSet);
                }
            }
            setList.addAll(artifactSetSet);
            Collections.sort(setList);
        }
        return setList;
    }

    protected String getUrl() {
        return this.url;
    }

    protected URIBuilder getURIBuilder(String ... additionalPathSegments) throws URISyntaxException {
        return this.getURIBuilder(Arrays.asList(additionalPathSegments));
    }

    protected URIBuilder getURIBuilder(List<String> additionalPathSegments) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(this.getUrl());
        ArrayList<String> pathSegments = new ArrayList<String>(uriBuilder.getPathSegments());
        if (additionalPathSegments != null) {
            pathSegments.addAll(additionalPathSegments);
        }
        uriBuilder.setPathSegments(pathSegments);
        return uriBuilder;
    }

    protected DefaultHttpClient getHttpClient() {
        return this.httpClient;
    }

    protected HttpGet createHttpGet(String url) {
        HttpGet method = new HttpGet(url);
        if (this.credentials != null) {
            String authToken = this.credentials.getAuthToken();
            if (!StringUtil.isEmpty((String)authToken)) {
                method.addHeader("Authorization-Token", authToken);
            }
            String username = this.credentials.getUsername();
            String password = this.credentials.getPassword();
            if (!StringUtil.isEmpty((String)username) && !StringUtil.isEmpty((String)password)) {
                CredentialsProvider credProvider = this.httpClient.getCredentialsProvider();
                UsernamePasswordCredentials clientCred = new UsernamePasswordCredentials(username, password);
                credProvider.setCredentials(AuthScope.ANY, (Credentials)clientCred);
            }
        }
        return method;
    }

    protected HttpResponse executeHttpMethod(HttpRequestBase request) throws ClientProtocolException, IOException {
        return this.getHttpClient().execute((HttpUriRequest)request);
    }

    private boolean exceptionContainsString(Throwable t, String searchStr) {
        while (t != null) {
            String message = t.getMessage();
            if (StringUtils.containsIgnoreCase((CharSequence)message, (CharSequence)searchStr)) {
                return true;
            }
            t = t.getCause();
        }
        return false;
    }
}

