/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.fileutils.filelister;

import com.urbancode.commons.fileutils.filelister.BestEffortPermissionReader;
import com.urbancode.commons.fileutils.filelister.FileExecuteOnlyPermissionReader;
import com.urbancode.commons.fileutils.filelister.FileLister;
import com.urbancode.commons.fileutils.filelister.FileListerExcludeAsLink;
import com.urbancode.commons.fileutils.filelister.FileListerExcludeExclude;
import com.urbancode.commons.fileutils.filelister.FileListerExcludeFollow;
import com.urbancode.commons.fileutils.filelister.FileListerFactory;
import com.urbancode.commons.fileutils.filelister.FileListerIncludeAllAsLink;
import com.urbancode.commons.fileutils.filelister.FileListerIncludeAllExclude;
import com.urbancode.commons.fileutils.filelister.FileListerIncludeAllFollow;
import com.urbancode.commons.fileutils.filelister.FileListerIncludeNonEmptyAsLink;
import com.urbancode.commons.fileutils.filelister.FileListerIncludeNonEmptyExclude;
import com.urbancode.commons.fileutils.filelister.FileListerIncludeNonEmptyFollow;
import com.urbancode.commons.fileutils.filelister.NullPermissionReader;
import com.urbancode.commons.fileutils.filelister.PermissionReader;
import com.urbancode.commons.fileutils.filelister.UnixPermissionReader;
import com.urbancode.commons.util.FilePatternFileFilter;
import com.urbancode.commons.util.unix.Unix;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileListerBuilder {
    private static final Logger log = Logger.getLogger(FileListerBuilder.class);
    private static final Map<Directories, Map<Symlinks, FileListerFactory>> factoryMap = new EnumMap<Directories, Map<Symlinks, FileListerFactory>>(Directories.class);
    private final Unix unix;
    private File base;
    private Directories directories = Directories.EXCLUDE;
    private Symlinks symlinks = Symlinks.FOLLOW;
    private Permissions permissions = Permissions.NONE;
    private Set<String> includes = new HashSet<String>();
    private Set<String> excludes = new HashSet<String>();

    private static void put(Directories directories, Symlinks symlinks, FileListerFactory factory) {
        if (directories == null) {
            throw new NullPointerException("directories");
        }
        if (symlinks == null) {
            throw new NullPointerException("symlinks");
        }
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        if (factoryMap.get((Object)directories).containsKey((Object)symlinks)) {
            throw new IllegalArgumentException("entry already initialized");
        }
        factoryMap.get((Object)directories).put(symlinks, factory);
    }

    public FileListerBuilder(File base) {
        this(base, new Unix());
    }

    public FileListerBuilder(File base, Unix unix) {
        if (base == null) {
            throw new NullPointerException("base");
        }
        if (unix == null) {
            throw new NullPointerException("unix");
        }
        this.base = base;
        this.unix = unix;
    }

    public void base(File base) {
        if (base == null) {
            throw new NullPointerException("base");
        }
        this.base = base;
    }

    public File base() {
        return this.base;
    }

    public Set<String> includes() {
        return this.includes;
    }

    public void include(String ... patterns) {
        if (patterns == null) {
            throw new NullPointerException("patterns");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Including patterns " + Arrays.asList(patterns)));
        }
        Collections.addAll(this.includes, patterns);
    }

    public Set<String> excludes() {
        return this.excludes;
    }

    public void exclude(String ... patterns) {
        if (patterns == null) {
            throw new NullPointerException("patterns");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Excluding patterns " + Arrays.asList(patterns)));
        }
        Collections.addAll(this.excludes, patterns);
    }

    public Directories directories() {
        return this.directories;
    }

    public void directories(Directories directories) {
        if (directories == null) {
            throw new NullPointerException("directories");
        }
        this.directories = directories;
    }

    public Permissions permissions() {
        return this.permissions;
    }

    public void permissions(Permissions permissions) {
        if (permissions == null) {
            throw new NullPointerException("permissions");
        }
        this.permissions = permissions;
    }

    public Symlinks symlinks() {
        return this.symlinks;
    }

    public void symlinks(Symlinks symlinks) {
        if (symlinks == null) {
            throw new NullPointerException("symlinks");
        }
        this.symlinks = symlinks;
    }

    public FileLister build() throws IOException {
        File base = this.base.getCanonicalFile();
        Directories directories = this.directories;
        Symlinks symlinks = this.symlinks;
        Permissions permissions = this.permissions;
        HashSet<String> includes = new HashSet<String>(this.includes);
        HashSet<String> excludes = new HashSet<String>(this.excludes);
        if (includes.contains(null)) {
            throw new IllegalStateException("Invalid includes: contains null");
        }
        if (excludes.contains(null)) {
            throw new IllegalStateException("Invalid excludes: contains null");
        }
        PermissionReader permissionReader = this.permissionReader(permissions);
        FileListerFactory factory = this.factory(directories, symlinks);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Building FileLister subtype " + factory.implementationName()));
            log.debug((Object)("base = " + base));
            log.debug((Object)("directories = " + (Object)((Object)directories)));
            log.debug((Object)("symlinks = " + (Object)((Object)symlinks)));
            log.debug((Object)("permissions = " + (Object)((Object)permissions)));
            log.debug((Object)("includes = " + includes));
            log.debug((Object)("excludes = " + excludes));
        }
        FilePatternFileFilter acceptor = new FilePatternFileFilter(base, includes, excludes);
        return factory.create(base, (FileFilter)acceptor, permissionReader);
    }

    private FileListerFactory factory(Directories directories, Symlinks symlinks) {
        return factoryMap.get((Object)directories).get((Object)symlinks);
    }

    private PermissionReader permissionReader(Permissions permissions) {
        switch (permissions) {
            case REQUIRED: {
                return this.newRequiredReader();
            }
            case BEST_EFFORT: {
                return this.newBestEffortReader();
            }
            case FILE_EXECUTE_ONLY: {
                return this.newFileExecuteOnlyReader();
            }
            case NONE: {
                return this.newNoneReader();
            }
        }
        throw new AssertionError();
    }

    private PermissionReader newRequiredReader() {
        return this.newPlatformReader();
    }

    private PermissionReader newBestEffortReader() {
        return new BestEffortPermissionReader(this.newPlatformReader());
    }

    private PermissionReader newFileExecuteOnlyReader() {
        return new FileExecuteOnlyPermissionReader(this.newBestEffortReader());
    }

    private PermissionReader newNoneReader() {
        return new NullPermissionReader();
    }

    private PermissionReader newPlatformReader() {
        PermissionReader result = new NullPermissionReader();
        if (this.unix.isUnix()) {
            result = new UnixPermissionReader(this.unix);
        }
        return result;
    }

    static {
        for (Directories d : Directories.values()) {
            factoryMap.put(d, new EnumMap(Symlinks.class));
        }
        FileListerBuilder.put(Directories.EXCLUDE, Symlinks.AS_LINK, FileListerExcludeAsLink.FACTORY);
        FileListerBuilder.put(Directories.EXCLUDE, Symlinks.EXCLUDE, FileListerExcludeExclude.FACTORY);
        FileListerBuilder.put(Directories.EXCLUDE, Symlinks.FOLLOW, FileListerExcludeFollow.FACTORY);
        FileListerBuilder.put(Directories.INCLUDE_ALL, Symlinks.AS_LINK, FileListerIncludeAllAsLink.FACTORY);
        FileListerBuilder.put(Directories.INCLUDE_ALL, Symlinks.EXCLUDE, FileListerIncludeAllExclude.FACTORY);
        FileListerBuilder.put(Directories.INCLUDE_ALL, Symlinks.FOLLOW, FileListerIncludeAllFollow.FACTORY);
        FileListerBuilder.put(Directories.INCLUDE_NON_EMPTY, Symlinks.AS_LINK, FileListerIncludeNonEmptyAsLink.FACTORY);
        FileListerBuilder.put(Directories.INCLUDE_NON_EMPTY, Symlinks.EXCLUDE, FileListerIncludeNonEmptyExclude.FACTORY);
        FileListerBuilder.put(Directories.INCLUDE_NON_EMPTY, Symlinks.FOLLOW, FileListerIncludeNonEmptyFollow.FACTORY);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Permissions {
        REQUIRED,
        BEST_EFFORT,
        FILE_EXECUTE_ONLY,
        NONE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Symlinks {
        EXCLUDE,
        FOLLOW,
        AS_LINK;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Directories {
        EXCLUDE,
        INCLUDE_NON_EMPTY,
        INCLUDE_ALL;

    }
}

