/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.codestation.client.util;

import com.urbancode.ubuild.codestation.client.util.error.EncryptionException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.codec.binary.Base64;

public class EncryptionHandler {
    private static final int ITERATION_COUNT = 999;
    private static final int PBE_SALT_LENGTH = 8;
    private static final int PBE_PWD_LENGTH = 32;
    private static final String PBE_ALG = "PBEWithMD5AndDES";
    private static final String PBE_HEADER = "PBEWithMD5AndDES{";
    private static final String PBE_FOOTER = "}";

    public static boolean isEncrypted(String value) {
        return value != null && value.startsWith(PBE_HEADER) && value.endsWith(PBE_FOOTER);
    }

    public static String encrypt(String value) {
        String result;
        block8: {
            try {
                if (value != null && !EncryptionHandler.isEncrypted(value)) {
                    byte[] data = value.getBytes("UTF-8");
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
                    byte[] salt = new byte[8];
                    sr.nextBytes(salt);
                    byte[] passByte = new byte[32];
                    sr.nextBytes(passByte);
                    for (int i = 0; i < passByte.length; ++i) {
                        passByte[i] = (byte)(passByte[i] % 26 + 97);
                    }
                    char[] password = new String(passByte, "US-ASCII").toCharArray();
                    PBEKeySpec keyspec = new PBEKeySpec(password, salt, 999);
                    SecretKey key = SecretKeyFactory.getInstance(PBE_ALG).generateSecret(keyspec);
                    Cipher cipher = Cipher.getInstance(PBE_ALG);
                    PBEParameterSpec paramspec = new PBEParameterSpec(salt, 999);
                    cipher.init(1, (Key)key, paramspec);
                    for (int i = 0; i < salt.length; ++i) {
                        baos.write(salt[i]);
                        baos.write(passByte[i]);
                    }
                    baos.write(passByte, salt.length, passByte.length - salt.length);
                    try {
                        baos.write(cipher.doFinal(data));
                    }
                    catch (IOException impossible) {
                        throw new AssertionError((Object)("encrypt " + impossible));
                    }
                    keyspec.clearPassword();
                    result = PBE_HEADER + new String(Base64.encodeBase64((byte[])baos.toByteArray()), "US-ASCII") + PBE_FOOTER;
                    break block8;
                }
                result = value;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new EncryptionException(e);
            }
        }
        return result;
    }

    public static String decrypt(String cryptValue) {
        String result;
        try {
            if (cryptValue != null && EncryptionHandler.isEncrypted(cryptValue)) {
                String strippedCrypt = cryptValue.substring(PBE_HEADER.length(), cryptValue.length() - PBE_FOOTER.length());
                byte[] data = Base64.decodeBase64((byte[])strippedCrypt.getBytes("US-ASCII"));
                if (data.length < 40) {
                    throw new IllegalArgumentException("Invalid Encrypted String");
                }
                byte[] passByte = new byte[32];
                byte[] salt = new byte[8];
                System.arraycopy(data, 16, passByte, 8, 24);
                for (int i = 0; i < 8; ++i) {
                    salt[i] = data[i * 2];
                    passByte[i] = data[i * 2 + 1];
                }
                char[] password = new String(passByte, "US-ASCII").toCharArray();
                PBEKeySpec keyspec = new PBEKeySpec(password, salt, 999);
                SecretKey key = SecretKeyFactory.getInstance(PBE_ALG).generateSecret(keyspec);
                PBEParameterSpec paramspec = new PBEParameterSpec(salt, 999);
                Cipher cipher = Cipher.getInstance(PBE_ALG);
                cipher.init(2, (Key)key, paramspec);
                byte[] output = cipher.doFinal(data, 40, data.length - 8 - 32);
                keyspec.clearPassword();
                result = new String(output, "UTF-8");
            } else {
                result = cryptValue;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EncryptionException(e);
        }
        return result;
    }
}

