/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.controller;

import com.urbancode.commons.profiler.Profiler;
import com.urbancode.commons.web.controller.ControllerServlet;
import com.urbancode.commons.web.controller.DynamicResponse;
import com.urbancode.commons.web.controller.URLResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class ForwardResponse
extends URLResponse
implements DynamicResponse {
    private static final Logger log = Logger.getLogger(ControllerServlet.class);
    private final String destination;
    private final List<URLResponse.Attr> attrList = new ArrayList<URLResponse.Attr>();
    private final List<URLResponse.Attr> sessionAttrList = new ArrayList<URLResponse.Attr>();

    public ForwardResponse(String destination) {
        this.destination = destination;
    }

    public void respond(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String activityName = Profiler.getInstance().startActivity("ForwardResponse.respond (" + this.destination + ")");
        log.debug((Object)("Forwarding to " + this.destination));
        this.addAttributes(request);
        request.getRequestDispatcher(this.destination).forward((ServletRequest)request, (ServletResponse)response);
        Profiler.getInstance().stopActivity(activityName);
    }

    public String getDestination() {
        return this.destination;
    }

    public ForwardResponse addAttr(String name, Object value) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        URLResponse.Attr attr = new URLResponse.Attr(name, value);
        this.attrList.add(attr);
        return this;
    }

    public ForwardResponse addSessionAttr(String name, Object value) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        URLResponse.Attr attr = new URLResponse.Attr(name, value);
        this.sessionAttrList.add(attr);
        return this;
    }

    private void addAttributes(HttpServletRequest request) {
        for (URLResponse.Attr attr : this.attrList) {
            request.setAttribute(attr.getName(), attr.getValue());
        }
        HttpSession session = request.getSession();
        for (URLResponse.Attr attr : this.sessionAttrList) {
            session.setAttribute(attr.getName(), attr.getValue());
        }
    }
}

