/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ds.client;

import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder2;
import com.urbancode.commons.util.StringUtil;
import com.urbancode.ds.client.ClientCommandOption;
import com.urbancode.ds.client.ClientConfiguration;
import com.urbancode.ds.client.HttpClientBuilderFactory;
import com.urbancode.ds.client.HttpMethodCallable;
import com.urbancode.ds.client.ParsedCommandLine;
import com.urbancode.vfs.common.EncodingUtil;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;

public class ClientCommand {
    public static final String APPLICATION_YAML = "application/yaml";
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_ZIP = "application/zip";
    private final ClientConfiguration config;
    private final String name;
    private final String[] aliases;
    private final String summary;
    private final List<String> statuses;
    private final String description;
    private final String httpMethod;
    private final String contentType;
    private final String url;
    private final List<ClientCommandOption> options = new ArrayList<ClientCommandOption>();
    private final String template;
    private final String inputFilename;
    private final String inputFileDescription;

    public ClientCommand(ClientConfiguration config, String name, String[] aliases, String summary, String description, String httpMethod, String contentType, String url, String template, String inputFilename, String inputFileDescription, List<String> statuses) {
        this.config = config;
        this.name = name;
        this.aliases = aliases;
        this.summary = summary;
        this.description = description;
        this.httpMethod = httpMethod;
        this.contentType = contentType;
        this.url = url;
        this.template = template;
        this.inputFilename = inputFilename;
        this.inputFileDescription = inputFileDescription;
        this.statuses = statuses;
    }

    public ClientConfiguration getConfig() {
        return this.config;
    }

    public String getName() {
        return this.name;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public String getSummary() {
        return this.summary;
    }

    public List<String> getResultStatuses() {
        return this.statuses;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getURL() {
        return this.url;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getInputfilename() {
        return this.inputFilename;
    }

    public String getInputFileDescription() {
        return this.inputFileDescription;
    }

    public void addOption(ClientCommandOption option) {
        this.options.add(option);
    }

    public ClientCommandOption getOptionByName(String name) {
        for (ClientCommandOption option : this.options) {
            if (!name.equals(option.getName())) continue;
            return option;
        }
        return null;
    }

    public ClientCommandOption[] getOptions() {
        return this.options.toArray(new ClientCommandOption[this.options.size()]);
    }

    public int execute(ParsedCommandLine parsedCommandLine, PrintStream out, PrintStream err, InputStream input, File file) throws Exception {
        FileEntity entity = null;
        if (file != null) {
            entity = new FileEntity(file);
        } else if (input != null) {
            entity = new BufferedHttpEntity((HttpEntity)new InputStreamEntity(input, -1L));
        }
        return this.execute(parsedCommandLine, out, err, (HttpEntity)entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int execute(ParsedCommandLine parsedCommandLine, PrintStream out, PrintStream err, HttpEntity requestEntity) throws Exception {
        String baseURL = parsedCommandLine.getOptionValue(this.getConfig().getWebUrlOption());
        baseURL = baseURL + (baseURL.endsWith("/") ? "cli" : "/cli");
        String url = this.getURL(baseURL, parsedCommandLine);
        HttpPost method = null;
        int responseCode = -1;
        if ("POST".equalsIgnoreCase(this.getHttpMethod())) {
            method = new HttpPost(url);
            if (requestEntity != null) {
                method.setEntity(requestEntity);
            }
        } else if ("GET".equalsIgnoreCase(this.getHttpMethod())) {
            method = new HttpGet(url);
        } else if ("PUT".equalsIgnoreCase(this.getHttpMethod())) {
            method = new HttpPut(url);
            if (requestEntity != null) {
                ((HttpPut)method).setEntity(requestEntity);
            }
        } else if ("DELETE".equalsIgnoreCase(this.getHttpMethod())) {
            method = new HttpDelete(url);
        } else {
            throw new RuntimeException("Unexpected method type: " + this.getHttpMethod());
        }
        String authToken = parsedCommandLine.getOptionValue(this.getConfig().getAuthTokenOption());
        String username = parsedCommandLine.getOptionValue(this.getConfig().getUsernameOption());
        String password = parsedCommandLine.getOptionValue(this.getConfig().getPasswordOption());
        if (authToken == null && (username == null || password == null)) {
            throw new Exception("Invalid security options: Either " + this.getConfig().getAuthTokenOption().getName() + " or " + this.getConfig().getUsernameOption().getName() + " and " + this.getConfig().getPasswordOption().getName() + " must be defined.");
        }
        if (username == null || password == null) {
            method.setHeader("Authorization-Token", authToken);
        }
        this.setContentTypeHeader((HttpRequestBase)method, parsedCommandLine);
        this.setAcceptHeader((HttpRequestBase)method, parsedCommandLine);
        HttpClientBuilder2 builder = HttpClientBuilderFactory.newBuilder(parsedCommandLine, this.getConfig());
        CloseableHttpClient client = builder.buildClient();
        try {
            responseCode = HttpMethodCallable.create((HttpClient)client, (HttpRequestBase)method, out, err).call();
        }
        finally {
            method.releaseConnection();
        }
        return responseCode;
    }

    void setContentTypeHeader(HttpRequestBase method, ParsedCommandLine parsedCommandLine) {
        String contentType = this.contentType;
        if (this.hasYamlExtension(parsedCommandLine.getFileName()) || parsedCommandLine.isFlagSet(ClientConfiguration.FLAG_YAML)) {
            contentType = APPLICATION_YAML;
        }
        if (!StringUtil.isEmpty(contentType)) {
            method.setHeader("Content-Type", contentType);
        }
    }

    void setAcceptHeader(HttpRequestBase method, ParsedCommandLine parsedCommandLine) {
        if (this.hasYamlExtension(parsedCommandLine.getFileName()) || parsedCommandLine.isFlagSet(ClientConfiguration.FLAG_YAML)) {
            method.setHeader("Accept", APPLICATION_YAML);
        }
    }

    boolean hasYamlExtension(String filename) {
        return filename != null && (StringUtil.endsWithIgnoreCase(filename, "yml") || StringUtil.endsWithIgnoreCase(filename, "yaml"));
    }

    protected String getURL(String baseURL, ParsedCommandLine parsedCommandLine) throws Exception {
        StringBuilder urlBuilder = new StringBuilder();
        if (baseURL.endsWith("/") && this.getURL().startsWith("/")) {
            urlBuilder.append(baseURL.substring(0, baseURL.length() - 1));
        } else {
            urlBuilder.append(baseURL);
        }
        boolean isProperty = false;
        for (String part : this.getURL().split("[{}]")) {
            if (isProperty) {
                ClientCommandOption option;
                int colonIndex = part.indexOf(58);
                if (colonIndex > 0) {
                    part = part.substring(0, colonIndex);
                }
                if ((option = this.getOptionByName(part)) == null) {
                    throw new Exception("Configuration for command '" + this.getName() + "' has a improperly formatted URL '" + this.getURL() + "'. Property not found: " + part);
                }
                String value = parsedCommandLine.getOptionValue(option);
                if (value != null) {
                    EncodingUtil encoder = new EncodingUtil();
                    String encodedValue = encoder.percentEncode(value);
                    urlBuilder.append(encodedValue);
                }
            } else {
                urlBuilder.append(part);
            }
            isProperty = !isProperty;
        }
        boolean firstQueryParam = true;
        for (ClientCommandOption option : this.options) {
            Set<String> values;
            if (!ClientCommandOption.ParamType.QUERY.equals((Object)option.getParamType()) || (values = parsedCommandLine.getOptionValues(option)) == null) continue;
            for (String value : values) {
                if (value == null) continue;
                value = URLEncoder.encode(value, "UTF-8");
                String optionName = URLEncoder.encode(option.getName(), "UTF-8");
                String queryParam = optionName + "=" + value;
                queryParam = firstQueryParam ? "?" + queryParam : "&" + queryParam;
                urlBuilder.append(queryParam);
                firstQueryParam = false;
            }
        }
        return urlBuilder.toString();
    }
}

