/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.authentication;

import com.urbancode.commons.web.WebConfig;
import com.urbancode.commons.web.WebException;
import com.urbancode.commons.web.authentication.AbstractCookieAuthenticator;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class SecureCookieAuthenticator
extends AbstractCookieAuthenticator {
    private final String ENCODING = "UTF-8";
    private final String AES_ALGORITHM = "AES";

    private String decodeCookieToken(String token, Key key) throws GeneralSecurityException, UnsupportedEncodingException {
        String result;
        if (token == null) {
            throw new IllegalArgumentException("Token cannot be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        byte[] base64CipherBytes = token.getBytes();
        if (Base64.isArrayByteBase64((byte[])base64CipherBytes)) {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, key);
            byte[] cipherBytes = Base64.decodeBase64((byte[])base64CipherBytes);
            byte[] plainBytes = cipher.doFinal(cipherBytes);
            result = new String(plainBytes, "UTF-8");
        } else {
            result = null;
        }
        return result;
    }

    private String createCookieToken(String creds, Key key) throws GeneralSecurityException, UnsupportedEncodingException {
        if (creds == null) {
            throw new IllegalArgumentException("Credentials cannot be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, key);
        byte[] plainBytes = creds.getBytes();
        byte[] cipherBytes = cipher.doFinal(plainBytes);
        byte[] base64CipherBytes = Base64.encodeBase64((byte[])cipherBytes);
        String result = new String(base64CipherBytes, "UTF-8");
        return result;
    }

    protected Key getKey() {
        return new SecretKeySpec(WebConfig.getInstance().getRawLoginCookieKey().getBytes(), "AES");
    }

    Key createKey() {
        SecretKey result = null;
        try {
            result = KeyGenerator.getInstance("AES").generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("AES is not supported");
        }
        return result;
    }

    String createCookieValue(String login, String password) throws WebException {
        String urlBase64CipherToken = null;
        try {
            String plainToken = login + "\u0000" + password;
            String base64CipherToken = this.createCookieToken(plainToken, this.getKey());
            urlBase64CipherToken = URLEncoder.encode(base64CipherToken, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"This should never happen", (Throwable)e);
        }
        catch (GeneralSecurityException e) {
            throw new WebException("Encoding login cookie", e);
        }
        return urlBase64CipherToken;
    }

    protected String[] getLoginAndPassword(String cookieValue) throws WebException {
        String[] credentials = null;
        String urlBase64CipherToken = cookieValue;
        try {
            String base64CipherToken = URLDecoder.decode(urlBase64CipherToken, "UTF-8");
            String plainToken = this.decodeCookieToken(base64CipherToken, this.getKey());
            if (plainToken != null) {
                credentials = plainToken.split("\u0000", 2);
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"This should never happen", (Throwable)e);
        }
        catch (GeneralSecurityException e) {
            throw new WebException("Decoding login cookie", e);
        }
        return credentials;
    }
}

