/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.proxy;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.Validate;

public class KeyedLockManager {
    final Map<String, CountingReentrantReadWriteLock> locks = new HashMap<String, CountingReentrantReadWriteLock>();

    public LockGrant tryLock(String key, Mode mode) {
        CountingReentrantReadWriteLock rwLock = this.getLockForKey(key);
        Lock l = this.getLockForMode(rwLock, mode);
        LockGrant0 grant = l.tryLock() ? new LockGrant0(key, rwLock, l) : null;
        return grant;
    }

    public LockGrant lock(String key, Mode mode) {
        CountingReentrantReadWriteLock rwLock = this.getLockForKey(key);
        Lock l = this.getLockForMode(rwLock, mode);
        l.lock();
        LockGrant0 grant = new LockGrant0(key, rwLock, l);
        return grant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CountingReentrantReadWriteLock getLockForKey(String key) {
        CountingReentrantReadWriteLock rwLock;
        Map<String, CountingReentrantReadWriteLock> map = this.locks;
        synchronized (map) {
            rwLock = this.locks.get(key);
            if (rwLock == null) {
                rwLock = new CountingReentrantReadWriteLock();
                this.locks.put(key, rwLock);
            }
            rwLock.incrementCount();
        }
        return rwLock;
    }

    private Lock getLockForMode(CountingReentrantReadWriteLock rwLock, Mode mode) {
        Lock l;
        if (Mode.SHARED == mode) {
            l = rwLock.readLock();
        } else if (Mode.EXCLUSIVE == mode) {
            l = rwLock.writeLock();
        } else {
            throw new IllegalArgumentException("Unknown mode " + (Object)((Object)mode));
        }
        return l;
    }

    private class LockGrant0
    implements LockGrant {
        final String key;
        final CountingReentrantReadWriteLock counter;
        final Lock l;

        public LockGrant0(String key, CountingReentrantReadWriteLock counter, Lock l) {
            this.key = (String)Validate.notNull((Object)key);
            this.counter = (CountingReentrantReadWriteLock)Validate.notNull((Object)counter);
            this.l = (Lock)Validate.notNull((Object)l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            this.l.unlock();
            Map<String, CountingReentrantReadWriteLock> map = KeyedLockManager.this.locks;
            synchronized (map) {
                if (this.counter.decrementCount()) {
                    KeyedLockManager.this.locks.remove(this.key);
                }
            }
        }

        public String toString() {
            return this.getClass().getName() + "{" + this.key + ":" + this.counter + "}";
        }
    }

    private class CountingReentrantReadWriteLock
    extends ReentrantReadWriteLock {
        private static final long serialVersionUID = 1L;
        int count;

        public CountingReentrantReadWriteLock() {
            super(true);
            this.count = 0;
        }

        public void incrementCount() {
            assert (Thread.holdsLock(KeyedLockManager.this.locks));
            ++this.count;
        }

        public boolean decrementCount() {
            assert (Thread.holdsLock(KeyedLockManager.this.locks));
            return --this.count == 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        SHARED,
        EXCLUSIVE;

    }

    public static interface LockGrant {
        public void release();
    }
}

