/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.vfs.common;

import com.urbancode.vfs.common.Encoding;
import com.urbancode.vfs.common.Hash;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class EncodingUtil {
    public byte[] decode(Encoding encoding, String encodedValue) throws DecoderException {
        byte[] bytes;
        if (Encoding.Hex.equals((Object)encoding)) {
            bytes = Hex.decodeHex((char[])encodedValue.toCharArray());
        } else if (Encoding.Base64.equals((Object)encoding)) {
            bytes = Base64.decodeBase64((byte[])encodedValue.getBytes());
        } else {
            throw new IllegalArgumentException("Unrecognized Encoding: " + (Object)((Object)encoding));
        }
        return bytes;
    }

    public byte[] decode(Hash hash) throws DecoderException {
        return this.decode(hash.getEncoding(), hash.getValue());
    }

    public String encode(Encoding encoding, byte[] value) {
        String encodedValue;
        if (Encoding.Hex.equals((Object)encoding)) {
            encodedValue = new String(Hex.encodeHex((byte[])value));
        } else if (Encoding.Base64.equals((Object)encoding)) {
            encodedValue = new String(Base64.encodeBase64((byte[])value));
        } else {
            throw new IllegalArgumentException("Unrecognized Encoding: " + (Object)((Object)encoding));
        }
        return encodedValue;
    }
}

