<%--
- Licensed Materials - Property of IBM* and/or HCL**
- UrbanCode Deploy
- UrbanCode Build
- UrbanCode Release
- AnthillPro
- (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
- (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
-
- U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
- GSA ADP Schedule Contract with IBM Corp.
-
- * Trademark of International Business Machines
- ** Trademark of HCL Technologies Limited
--%>
<%@tag body-content="empty" %>

<%@attribute name="name"    required="true"%>
<%@attribute name="id"      required="false"%>
<%@attribute name="label"   required="false"%>
<%@attribute name="href"    required="false"%>
<%@attribute name="onclick" required="false"%>
<%@attribute name="submit"  required="false"%>
<%@attribute name="enabled" required="false" type="java.lang.Boolean"%>
<%@attribute name="cssclass"   required="false"%>
<%@attribute name="title"   required="false"%>

<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>

<c:if test="${label==null}">
  <c:set var="label" value="${name}"/>
</c:if>

<c:if test="${enabled==null}">
 <c:set var="enabled"  value="true"/>
</c:if>

<c:if test="${cssclass==null}">
 <c:set var="cssclass"  value="button"/>
</c:if>

<c:choose>
  <c:when test="${empty name}">
    <span style="font-weight: bold; color:red">ERROR: NAME ATTRIBUTE IS EMPTY</b>
  </c:when>
  
  <c:otherwise>
    <c:choose>
      <c:when test="${!enabled}">
        <input type="${empty submit || submit ? "submit" : "button"}" 
          <c:if test="${!empty id}">id="${fn:escapeXml(id)}"</c:if> 
          name="${fn:escapeXml(name)}" value="${fn:escapeXml(label)}" class="${cssclass}disabled" <c:if test="${!empty title}">title="${fn:escapeXml(title)}"</c:if> disabled="disabled"/>
      </c:when>
      <c:when test="${href==null}">
        <input type="${empty submit || submit ? "submit" : "button"}" 
          <c:if test="${!empty id}">id="${fn:escapeXml(id)}"</c:if> 
          name="${fn:escapeXml(name)}" value="${fn:escapeXml(label)}" class="${cssclass}" <c:if test="${!empty title}">title="${fn:escapeXml(title)}"</c:if> <c:if test="${!empty onclick}">onclick="${onclick}"</c:if>/>
      </c:when>
      <c:otherwise>
        <input type="button" class="${cssclass}" <c:if test="${!empty id}">id="${fn:escapeXml(id)}"</c:if> name="${fn:escapeXml(name)}" value="${fn:escapeXml(label)}" <c:if test="${!empty title}">title="${fn:escapeXml(title)}"</c:if> onclick="${onclick}; window.location='${href}'" />
      </c:otherwise>
    </c:choose>
  </c:otherwise>
</c:choose>
