<%--
- Licensed Materials - Property of IBM* and/or HCL**
- UrbanCode Deploy
- UrbanCode Build
- UrbanCode Release
- AnthillPro
- (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
- (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
-
- U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
- GSA ADP Schedule Contract with IBM Corp.
-
- * Trademark of International Business Machines
- ** Trademark of HCL Technologies Limited
--%>
<%@tag body-content="empty" %>

<%@attribute name="name"        required="true"%>
<%@attribute name="list"        required="true"     type="java.lang.Object"%>
<%@attribute name="valueList"   required="false"    type="java.lang.Object"%>
<%@attribute name="selectedValue" required="false" %>
<%@attribute name="selectedValues" required="false" type="java.util.Collection"%>
<%@attribute name="emptyMessage" required="false"%>
<%@attribute name="emptyMessageDisabled" required="false" type="java.lang.Boolean"%>
<%@attribute name="canUnselect" required="false" type="java.lang.Boolean" %>
<%@attribute name="multiple" required="false" type="java.lang.Boolean" %>
<%@attribute name="enabled"     required="false"    type="java.lang.Boolean"%>
<%@attribute name="id"           required="false" type="java.lang.String"%>

<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>

<c:set var="enabled" value="${empty enabled || enabled}"/>

<c:if test="${canUnselect && emptyMessage == null}">
  <c:set var="emptyMessage" value="None"/>
</c:if>

<c:if test="${empty valueList}">
  <c:set var="valueList" value="${list}"/>
</c:if>

<select name="${fn:escapeXml(name)}" 
    class="<c:if test="${!enabled}">inputdisabled</c:if>"
    <c:if test="${!empty id}">id="${fn:escapeXml(id)}"</c:if>
    <c:if test="${multiple}">multiple="multiple"</c:if>
    <c:if test="${!enabled}">disabled="disabled"</c:if>
  >

  <c:if test="${not multiple}">
    <option <c:if test="${empty selectedValue && empty selectedValues}">selected='selected'</c:if> value="" ${(emptyMessageDisabled)?"disabled=\"disabled\"":""}>-- <c:out value="${emptyMessage}" default="Make Selection"/> --</option>
  </c:if>
  
  <c:forEach var="temp" items="${list}" varStatus="status">
    <c:set var="value" value="${valueList[status.count - 1]}"/>
    <c:set var="selected" value="${value == selectedValue}"/>
    <c:forEach var="tmpSelectedValue" items="${selectedValues}">
      <c:if test="${value == tmpSelectedValue}">
        <c:set var="selected" value="${true}"/>
      </c:if>
    </c:forEach>

    <option <c:if test="${selected}">selected="selected"</c:if> value="${fn:escapeXml(value)}">${fn:escapeXml(temp)}</option>
  </c:forEach>

</select>