/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class AsynchronousStreamPumper
extends Thread {
    private static final Logger log = Logger.getLogger(AsynchronousStreamPumper.class);
    private static final int SIZE = 128;
    private static final int SLEEP_TIME = 50;
    private InputStream is = null;
    private OutputStream os = null;
    private boolean closeOutputStream = false;

    public AsynchronousStreamPumper(InputStream is, OutputStream os) {
        this.setDaemon(true);
        this.is = is;
        this.os = os;
    }

    public AsynchronousStreamPumper(InputStream is, OutputStream os, boolean closeOutputStream) {
        this.setDaemon(true);
        this.is = is;
        this.os = os;
        this.closeOutputStream = closeOutputStream;
    }

    public void run() {
        boolean shouldWrite = this.os != null;
        byte[] buf = new byte[128];
        int length = 0;
        try {
            while ((length = this.is.read(buf)) > 0) {
                if (shouldWrite) {
                    this.os.write(buf, 0, length);
                }
                try {
                    AsynchronousStreamPumper.sleep(50L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                    break;
                }
            }
            if (shouldWrite && (length = this.is.read(buf)) > 0) {
                this.os.write(buf, 0, length);
            }
            if (shouldWrite) {
                this.os.flush();
            }
            if (this.closeOutputStream) {
                this.os.close();
            }
        }
        catch (IOException ioe) {
            log.error(ioe, ioe);
        }
    }
}

