/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.controller;

import com.urbancode.commons.io.StreamPumper;
import com.urbancode.commons.web.controller.DynamicResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FileViewResponse
implements DynamicResponse {
    private static final MimetypesFileTypeMap mimeTypeMap = new MimetypesFileTypeMap();
    private final String contentType;
    private final File contentFile;
    private final String contentAlias;

    public FileViewResponse(File contentFile) {
        this(mimeTypeMap.getContentType(contentFile), contentFile, contentFile.getName());
    }

    public FileViewResponse(File contentFile, String alias) {
        this(mimeTypeMap.getContentType(contentFile), contentFile, alias);
    }

    public FileViewResponse(String contentType, File contentFile, String alias) {
        this.contentType = contentType;
        this.contentFile = contentFile;
        this.contentAlias = alias != null ? alias : contentFile.getName();
    }

    public void respond(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType(this.contentType);
        response.setContentLength((int)this.contentFile.length());
        response.setHeader("Pragma", "public");
        response.setHeader("Cache-Control", "max-age=0");
        String header = "filename=\"" + this.contentAlias.replaceAll("\"", "\\\\\"") + "\"";
        response.setHeader("Content-disposition", header);
        InputStream in = null;
        try {
            ServletOutputStream os = response.getOutputStream();
            in = new FileInputStream(this.contentFile);
            StreamPumper.pump(in, (OutputStream)os);
            os.flush();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

