/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ud.client;

import com.urbancode.ud.client.UDRestClient;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationClient
extends UDRestClient {
    public ApplicationClient(URI url, String clientUser, String clientPassword, boolean trustAllCerts) {
        super(url, clientUser, clientPassword, trustAllCerts);
    }

    public ApplicationClient(URI url, String clientUser, String clientPassword) {
        super(url, clientUser, clientPassword);
    }

    public ApplicationClient(URI url, DefaultHttpClient client) {
        super(url, client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addComponentToApplication(String appName, String compName) throws IOException {
        String result = null;
        String uri = this.url + "/cli/application/addComponentToApp?application=" + this.encodePath(appName) + "&component=" + this.encodePath(compName);
        HttpPut method = new HttpPut(uri);
        CloseableHttpResponse response = this.invokeMethod(method);
        try {
            result = this.getBody(response);
        }
        finally {
            response.close();
        }
        return result;
    }

    public String addTagToApplication(String appName, String tagName) throws IOException {
        String result = null;
        String uri = this.url + "/cli/application/tag?application=" + this.encodePath(appName) + "&tag=" + this.encodePath(tagName);
        HttpPut method = new HttpPut(uri);
        CloseableHttpResponse response = this.invokeMethod(method);
        result = this.getBody(response);
        return result;
    }

    public void addApplicationToTeam(String application, String team, String type) throws IOException {
        String uri = this.url + "/cli/application/teams?team=" + this.encodePath(team) + "&type=" + this.encodePath(type) + "&application=" + this.encodePath(application);
        HttpPut method = new HttpPut(uri);
        this.invokeMethod(method);
    }

    public UUID createApplication(String appName, String description, String notificationScheme, boolean enforceCompleteSnapshots) throws JSONException, IOException {
        UUID result = null;
        JSONObject jsonToSend = new JSONObject();
        jsonToSend.put("name", appName);
        jsonToSend.put("enforceCompleteSnapshots", enforceCompleteSnapshots);
        if (!"".equals(description) && description != null) {
            jsonToSend.put("description", description);
        }
        if (!"".equals(notificationScheme) && !"none".equalsIgnoreCase(notificationScheme) && notificationScheme != null) {
            jsonToSend.put("notificationScheme", notificationScheme);
        }
        String uri = this.url + "/cli/application/create";
        HttpPut method = new HttpPut(uri);
        method.setEntity(this.getStringEntity(jsonToSend));
        CloseableHttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        JSONObject jsonResult = new JSONObject(body);
        result = UUID.fromString((String)jsonResult.get("id"));
        return result;
    }

    public UUID createApplicationFromTemplate(String appName, String description, String notificationScheme, boolean enforceCompleteSnapshots, String templateId, String templateName, String templateVersion, String[] existingComponentIds) throws JSONException, IOException {
        UUID result = null;
        JSONObject jsonToSend = new JSONObject();
        jsonToSend.put("name", appName);
        jsonToSend.put("enforceCompleteSnapshots", enforceCompleteSnapshots);
        if (!StringUtils.isEmpty(description)) {
            jsonToSend.put("description", description);
        }
        if (!StringUtils.isEmpty(notificationScheme) && !notificationScheme.equalsIgnoreCase("none")) {
            jsonToSend.put("notificationScheme", notificationScheme);
        }
        if (!StringUtils.isEmpty(templateId)) {
            jsonToSend.put("templateId", templateId);
        }
        if (!StringUtils.isEmpty(templateName)) {
            jsonToSend.put("templateName", templateName);
        }
        if (!StringUtils.isEmpty(templateVersion)) {
            jsonToSend.put("templateVersion", templateVersion);
        }
        if (existingComponentIds != null && existingComponentIds.length > 0) {
            JSONArray jsonOfExistingComponentsIds = new JSONArray();
            for (String id : existingComponentIds) {
                jsonOfExistingComponentsIds.put(id);
            }
            jsonToSend.put("existingComponentIds", jsonOfExistingComponentsIds);
        }
        String uri = this.url + "/cli/application/createApplicationFromTemplate";
        HttpPut method = new HttpPut(uri);
        method.setEntity(this.getStringEntity(jsonToSend));
        CloseableHttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        JSONObject jsonResult = new JSONObject(body);
        result = UUID.fromString((String)jsonResult.get("id"));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID createApplicationProcess(String jsonStringIn) throws IOException, JSONException {
        UUID result = null;
        JSONObject jsonToSend = new JSONObject(jsonStringIn);
        String uri = this.url + "/cli/applicationProcess/create";
        HttpPut method = new HttpPut(uri);
        method.setEntity(this.getStringEntity(jsonToSend));
        CloseableHttpResponse response = this.invokeMethod(method);
        try {
            String body = this.getBody(response);
            JSONObject jsonResult = new JSONObject(body);
            result = UUID.fromString((String)jsonResult.get("id"));
        }
        finally {
            response.close();
        }
        return result;
    }

    public JSONArray getApplicationProcessRequestVersions(String processId) throws IOException, JSONException {
        JSONArray result = null;
        String uri = this.url + "/rest/deploy/applicationProcessRequest/" + this.encodePath(processId.toString()) + "/versions";
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod(method);
        try {
            JSONObject props = new JSONObject(this.getBody(response));
            result = props.getJSONArray("versions");
        }
        catch (JSONException e) {
            result = new JSONArray(this.getBody(response));
        }
        return result;
    }

    public JSONArray getApplicationProcessRequestProperties(String processId) throws IOException, JSONException {
        JSONArray result = null;
        String uri = this.url + "/rest/deploy/applicationProcessRequest/" + this.encodePath(processId.toString()) + "/properties";
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod(method);
        try {
            JSONObject props = new JSONObject(this.getBody(response));
            result = props.getJSONArray("properties");
        }
        catch (JSONException e) {
            result = new JSONArray(this.getBody(response));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getApplicationProcessStatus(String processID) throws IOException, JSONException {
        String result = null;
        String uri = this.url + "/cli/applicationProcessRequest/requestStatus?request=" + this.encodePath(processID);
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod(method);
        try {
            String body = this.getBody(response);
            JSONObject resultAsJSON = new JSONObject(body);
            result = resultAsJSON.getString("result");
        }
        finally {
            response.close();
        }
        return result;
    }

    public JSONObject getSnapshot(String application, String snapshot) throws IOException, JSONException {
        JSONObject result = null;
        String uri = this.url + "/rest/deploy/application/" + this.encodePath(application) + "/snapshots/false";
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        JSONArray resultJSON = new JSONArray(body);
        for (int i = 0; i < resultJSON.length(); ++i) {
            JSONObject snapshotJson = (JSONObject)resultJSON.get(i);
            String resultName = (String)snapshotJson.get("name");
            String resultId = (String)snapshotJson.get("id");
            if (!snapshot.equals(resultName) && !snapshot.equals(resultId)) continue;
            result = snapshotJson;
            break;
        }
        if (result == null) {
            throw new IOException("Could not find snapshot '" + snapshot + "'");
        }
        return result;
    }

    public JSONArray getSnapshotVersions(String snapshot) throws IOException, JSONException {
        JSONArray result = null;
        String uri = this.url + "/rest/deploy/snapshot/" + this.encodePath(snapshot) + "/versions";
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        result = new JSONArray(body);
        return result;
    }

    public JSONObject getApplication(String appName) throws IOException, JSONException {
        JSONObject result = null;
        String uri = this.url + "/cli/application/info?application=" + this.encodePath(appName);
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        result = new JSONObject(body);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray getApplicationComponents(String appName) throws IOException, JSONException {
        JSONArray result = null;
        String uri = this.url + "/cli/application/componentsInApplication?application=" + this.encodePath(appName);
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod(method);
        try {
            String body = this.getBody(response);
            result = new JSONArray(body);
        }
        finally {
            response.close();
        }
        return result;
    }

    public UUID requestApplicationProcess(String appName, String processName, String description, String envName, String snapshot, boolean onlyChanged, Map<String, List<String>> componentVersions) throws IOException, JSONException {
        return this.requestApplicationProcess(appName, processName, description, envName, snapshot, onlyChanged, componentVersions, new HashMap<String, String>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID requestApplicationProcess(String appName, String processName, String description, String envName, String snapshot, boolean onlyChanged, Map<String, List<String>> componentVersions, Map<String, String> requestProps) throws IOException, JSONException {
        String value;
        UUID result = null;
        JSONObject jsonToSend = new JSONObject();
        jsonToSend.put("application", appName).put("applicationProcess", processName).put("environment", envName).put("onlyChanged", onlyChanged);
        if (!"".equals(description) && description != null) {
            jsonToSend.put("description", description);
        }
        if (!"".equals(snapshot) && snapshot != null) {
            jsonToSend.put("snapshot", snapshot);
        }
        JSONArray cvMappings = new JSONArray();
        Set<String> keys = componentVersions.keySet();
        for (String component : keys) {
            List<String> versions = componentVersions.get(component);
            for (String version : versions) {
                JSONObject cvMapping = new JSONObject().put("component", component).put("version", version);
                cvMappings.put(cvMapping);
            }
        }
        jsonToSend.put("versions", cvMappings);
        JSONArray unfilledProps = this.getUnfilledApplicationProcessRequestProperties(appName, processName, snapshot);
        JSONObject properties = new JSONObject();
        if (unfilledProps.length() > 0) {
            for (int i = 0; i < unfilledProps.length(); ++i) {
                JSONObject property = unfilledProps.getJSONObject(i);
                String name = property.getString("name");
                value = property.getString("value");
                properties.put(name, value);
            }
        }
        if (requestProps.size() > 0) {
            Set<String> nameKeys = requestProps.keySet();
            for (String name : nameKeys) {
                value = requestProps.get(name);
                properties.put(name, value);
            }
        }
        jsonToSend.put("properties", properties);
        String uri = this.url + "/cli/applicationProcessRequest/request";
        HttpPut method = new HttpPut(uri);
        method.setEntity(this.getStringEntity(jsonToSend));
        CloseableHttpResponse response = this.invokeMethod(method);
        try {
            String body = this.getBody(response);
            JSONObject jsonResult = new JSONObject(body);
            result = UUID.fromString((String)jsonResult.get("requestId"));
        }
        finally {
            response.close();
        }
        return result;
    }

    public JSONArray checkUnfilledApplicationProcessRequestProperties(String appName, String processName, Map<String, String> requestProps) throws IOException, JSONException {
        return this.checkUnfilledApplicationProcessRequestProperties(appName, processName, null, requestProps);
    }

    public JSONArray checkUnfilledApplicationProcessRequestProperties(String appName, String processName, String snapshotName, Map<String, String> requestProps) throws IOException, JSONException {
        JSONArray result = new JSONArray();
        JSONArray unfilledProps = this.getUnfilledApplicationProcessRequestProperties(appName, processName, snapshotName);
        if (unfilledProps.length() > 0) {
            for (int i = 0; i < unfilledProps.length(); ++i) {
                JSONObject property = unfilledProps.getJSONObject(i);
                String name = property.getString("name");
                String value = property.getString("value");
                Boolean required = property.getBoolean("required");
                if (!required.booleanValue() || !StringUtils.isEmpty(requestProps.get(name)) || !StringUtils.isEmpty(value)) continue;
                result.put(property);
            }
        }
        return result;
    }

    public JSONArray getUnfilledApplicationProcessRequestProperties(String appName, String processName) throws IOException, JSONException {
        return this.getUnfilledApplicationProcessRequestProperties(appName, processName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray getUnfilledApplicationProcessRequestProperties(String appName, String processName, String snapshotName) throws IOException, JSONException {
        JSONArray properties;
        String uri = this.url + "/cli/applicationProcess/unfilledProperties?application=" + this.encodePath(appName) + "&processName=" + this.encodePath(processName);
        if (StringUtils.isNotEmpty(snapshotName)) {
            uri = uri + "&snapshot=" + this.encodePath(snapshotName);
        }
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod(method);
        try {
            String body = this.getBody(response);
            properties = new JSONArray(body);
        }
        finally {
            response.close();
        }
        return properties;
    }

    public void setApplicationProcessRequestProperty(String processId, String name, String value, boolean isSecure) throws IOException, JSONException {
        if (StringUtils.isEmpty(processId)) {
            throw new IOException("processId was not supplied");
        }
        if (StringUtils.isEmpty(name)) {
            throw new IOException("name was not supplied");
        }
        String uri = this.url + "/rest/deploy/applicationProcessRequest/" + this.encodePath(processId) + "/saveProperties";
        JSONArray props = new JSONArray();
        props.put(this.createNewPropertyJSON(name, value, isSecure));
        HttpPut method = new HttpPut(uri);
        method.setEntity(this.getStringEntity(props));
        this.invokeMethod(method);
    }

    public String setApplicationProperty(String appName, String name, String value, boolean isSecure) throws IOException {
        if ("".equals(appName) || "".equals(name)) {
            throw new IOException("a required argument was not supplied");
        }
        String uri = this.url + "/cli/application/propValue";
        HttpPut method = null;
        if (this.isStampCurrent()) {
            JSONObject entity = new JSONObject();
            try {
                entity.put("application", appName).put("name", name).put("value", value).put("isSecure", isSecure);
            }
            catch (JSONException e) {
                throw new IOException(e.getMessage(), e);
            }
            method = new HttpPut(uri);
            method.setEntity(new StringEntity(entity.toString()));
        } else {
            uri = uri + "?application=" + this.encodePath(appName) + "&name=" + this.encodePath(name) + "&value=" + this.encodePath(value) + "&isSecure=" + this.encodePath(String.valueOf(isSecure));
            method = new HttpPut(uri);
        }
        this.retryInvokeMethod(method, "set application property");
        String result = isSecure ? name + "=****" : name + "=" + value;
        return result;
    }

    public UUID createSnapshot(String snapshotName, String description, String applicationName, Map<String, List<String>> versions) throws JSONException, IOException {
        UUID result = null;
        JSONObject jsonToSend = new JSONObject();
        jsonToSend.put("name", snapshotName);
        jsonToSend.put("application", applicationName);
        if (!StringUtils.isEmpty(description)) {
            jsonToSend.put("description", description);
        }
        JSONArray versionArray = new JSONArray();
        if (versions != null) {
            for (String componentName : versions.keySet()) {
                List<String> versionNames = versions.get(componentName);
                for (String versionName : versionNames) {
                    JSONObject pairing = new JSONObject();
                    pairing.put(componentName, versionName);
                    versionArray.put(pairing);
                }
            }
        }
        jsonToSend.put("versions", versionArray);
        String uri = this.url + "/cli/snapshot/createSnapshot";
        HttpPut method = new HttpPut(uri);
        method.setEntity(this.getStringEntity(jsonToSend));
        CloseableHttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        JSONObject jsonResult = new JSONObject(body);
        result = UUID.fromString((String)jsonResult.get("id"));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID createSnapshotOfEnvironment(String environmentName, String applicationName, String name, String description) throws IOException, JSONException {
        UUID result = null;
        String uri = this.url + "/cli/snapshot/createSnapshotOfEnvironment?environment=" + this.encodePath(environmentName) + "&name=" + this.encodePath(name);
        if (!StringUtils.isEmpty(applicationName)) {
            uri = uri + "&application=" + this.encodePath(applicationName);
        }
        if (!StringUtils.isEmpty(description)) {
            uri = uri + "&description=" + this.encodePath(description);
        }
        HttpPut method = new HttpPut(uri);
        CloseableHttpResponse response = this.invokeMethod(method);
        try {
            String body = this.getBody(response);
            JSONObject jsonResult = new JSONObject(body);
            result = UUID.fromString((String)jsonResult.get("id"));
        }
        finally {
            response.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getApplicationProcess(String appName, String processName) throws IOException, JSONException {
        JSONObject result = null;
        String uri = this.url + "/cli/applicationProcess/info?application=" + this.encodePath(appName) + "&applicationProcess=" + this.encodePath(processName);
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod(method);
        try {
            if (response.getStatusLine().getStatusCode() == 204) {
                throw new IOException("404 Not Found");
            }
            String body = this.getBody(response);
            result = new JSONObject(body);
        }
        finally {
            response.close();
        }
        return result;
    }

    public JSONArray getApplicationEnvironments(String appName, String active, String inactive) throws IOException, JSONException {
        JSONArray result = null;
        String uri = this.url + "/cli/application/environmentsInApplication?application=" + this.encodePath(appName) + "&active=" + this.encodePath(active) + "&inactive=" + this.encodePath(inactive);
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        result = new JSONArray(body);
        return result;
    }

    public JSONObject removeComponentFromApplication(String[] components, String applicationName) throws IOException, JSONException {
        String applicationId = this.getApplicationUUID(applicationName).toString();
        JSONArray list = new JSONArray();
        for (String component : components) {
            String componentId = this.getComponentUUID(component).toString();
            list.put(componentId);
        }
        JSONObject jsonToSend = new JSONObject();
        jsonToSend.put("components", list);
        String uri = this.url + "/rest/deploy/application/" + this.encodePath(applicationId) + "/removeComponents";
        HttpPut method = new HttpPut(uri);
        method.setEntity(this.getStringEntity(jsonToSend));
        CloseableHttpResponse response = this.retryInvokeMethod(method, null);
        String body = this.getBody(response);
        JSONObject result = new JSONObject(body);
        return result;
    }

    public String removeTagFromApplication(String appName, String tagName) throws IOException {
        String result = null;
        String uri = this.url + "/cli/application/tag?application=" + this.encodePath(appName) + "&tag=" + this.encodePath(tagName);
        HttpDelete method = new HttpDelete(uri);
        CloseableHttpResponse response = this.invokeMethod(method);
        result = this.getBody(response);
        return result;
    }

    public UUID deleteApplication(String applicationName) throws IOException, JSONException {
        UUID appUUID = this.getApplicationUUID(applicationName);
        String uri = this.url + "/rest/deploy/application/" + appUUID.toString();
        HttpDelete method = new HttpDelete(uri);
        this.invokeMethod(method);
        return appUUID;
    }

    private UUID getApplicationUUID(String applicationName) throws IOException, JSONException {
        UUID result = null;
        String uri = this.url + "/cli/application/info?application=" + this.encodePath(applicationName);
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        JSONObject resultJSON = new JSONObject(body);
        result = UUID.fromString(resultJSON.getString("id"));
        return result;
    }

    private UUID getComponentUUID(String component) throws IOException, JSONException {
        UUID result = null;
        String uri = this.url + "/cli/component/info?component=" + this.encodePath(component);
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        JSONObject resultJSON = new JSONObject(body);
        result = UUID.fromString(resultJSON.getString("id"));
        return result;
    }
}

