/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ds.client;

import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder;
import com.urbancode.commons.util.StringUtil;
import com.urbancode.ds.client.ClientConfiguration;
import com.urbancode.ds.client.MissingRequiredParameterException;
import com.urbancode.ds.client.ParsedCommandLine;

public class HttpClientBuilderFactory {
    public static final String FLAG_HELP = "help";
    public static final String FLAG_VERBOSE = "verbose";
    public static final String OPTION_PROXY_HOST = "proxyHost";
    public static final String OPTION_PROXY_PORT = "proxyPort";
    public static final String OPTION_PROXY_USER = "proxyUser";
    public static final String OPTION_PROXY_PASS = "proxyPassword";
    public static final String OPTION_WEB_URL = "weburl";
    public static final String OPTION_AUTH_TOKEN = "authtoken";
    public static final String OPTION_USERNAME = "username";
    public static final String OPTION_PASSWORD = "password";
    public static final String OPTION_VERIFY_IDENTITY = "verifyServerIdentity";
    public static final String ENV_PROXY_HOST = "proxyHost";
    public static final String ENV_PROXY_PORT = "proxyPort";
    public static final String ENV_PROXY_USER = "proxyUser";
    public static final String ENV_PROXY_PASS = "proxyPassword";
    public static final String ENV_WEB_URL = "DS_WEB_URL";
    public static final String ENV_AUTH_TOKEN = "DS_AUTH_TOKEN";
    public static final String ENV_USERNAME = "DS_USERNAME";
    public static final String ENV_PASSWORD = "DS_PASSWORD";
    public static final String ENV_VERIFY_IDENTITY = "UC_TLS_VERIFY_CERTS";

    public static HttpClientBuilder newBuilder(ParsedCommandLine parsedCommandLine, ClientConfiguration config) throws MissingRequiredParameterException {
        String username = parsedCommandLine.getOptionValue(config.getUsernameOption());
        String password = parsedCommandLine.getOptionValue(config.getPasswordOption());
        String proxyHost = parsedCommandLine.getOptionValue(config.getProxyHostOption());
        String proxyPortString = parsedCommandLine.getOptionValue(config.getProxyPortOption());
        String proxyUser = parsedCommandLine.getOptionValue(config.getProxyUserOption());
        String proxyPassword = parsedCommandLine.getOptionValue(config.getPasswordOption());
        String checkServerCert = parsedCommandLine.getOptionValue(config.getVerifyServerIdentityOption());
        boolean verbose = parsedCommandLine.isFlagSet(ClientConfiguration.FLAG_VERBOSE);
        return HttpClientBuilderFactory.setup(username, password, proxyHost, proxyPortString, proxyUser, proxyPassword, checkServerCert, verbose);
    }

    public static HttpClientBuilder newBuilder(ParsedCommandLine parsedCommandLine) throws MissingRequiredParameterException {
        String username = parsedCommandLine.getOptionValue(OPTION_USERNAME, true);
        String password = parsedCommandLine.getOptionValue(OPTION_PASSWORD, true);
        String proxyHost = parsedCommandLine.getOptionValue("proxyHost", null, "proxyHost", null, false);
        String proxyPortString = parsedCommandLine.getOptionValue("proxyPort", null, "proxyPort", null, false);
        String proxyUser = parsedCommandLine.getOptionValue("proxyUser", null, "proxyUser", null, false);
        String proxyPassword = parsedCommandLine.getOptionValue("proxyPassword", null, "proxyPassword", null, false);
        String checkServerCert = parsedCommandLine.getOptionValue(OPTION_VERIFY_IDENTITY, null, ENV_VERIFY_IDENTITY, null, false);
        boolean verbose = parsedCommandLine.isFlagSet(ClientConfiguration.FLAG_VERBOSE);
        return HttpClientBuilderFactory.setup(username, password, proxyHost, proxyPortString, proxyUser, proxyPassword, checkServerCert, verbose);
    }

    private static HttpClientBuilder setup(String username, String password, String proxyHost, String proxyPortString, String proxyUsername, String proxyPassword, String checkServerCert, boolean verbose) {
        HttpClientBuilder builder = new HttpClientBuilder();
        Boolean verifyServerIdentity = Boolean.valueOf(checkServerCert);
        builder.setTrustAllCerts(verifyServerIdentity == false);
        if (username != null && password != null) {
            builder.setUsername(username);
            builder.setPassword(password);
            builder.setPreemptiveAuthentication(false);
        }
        if (!StringUtil.isEmpty(proxyHost)) {
            int proxyPort = 80;
            if (!StringUtil.isEmpty(proxyPortString)) {
                try {
                    proxyPort = Integer.valueOf(proxyPortString);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (verbose) {
                System.out.println("Using " + proxyPort + " for proxy port.");
            }
            builder.setProxyHost(proxyHost);
            builder.setProxyPort(proxyPort);
            if (!StringUtil.isEmpty(proxyUsername) && !StringUtil.isEmpty(proxyPassword)) {
                if (verbose) {
                    System.out.println("Setting proxy username and password.");
                }
                builder.setProxyUsername(proxyUsername);
                builder.setProxyPassword(proxyPassword);
            }
        }
        return builder;
    }
}

