/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ud.client;

import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder;
import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.web.util.PercentCodec;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDRestClient {
    private static final Logger log = Logger.getLogger(UDRestClient.class);
    static final int RETRY_LIMIT = 10;
    static final int RETRY_MAX_BACKOFF = 30000;
    static final int BACK_OFF_FACTOR = 200;
    protected final URI url;
    protected final String clientUser;
    protected final String clientPassword;
    protected final DefaultHttpClient client;
    protected Set<String> features = null;
    DefaultHandler handler = new DefaultHandler(){
        boolean setVersionProperty = false;
        Stack<String> elementStack = new Stack();

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            Iterator iter;
            String parent = null;
            if (this.elementStack.size() > 0) {
                parent = this.elementStack.peek();
            }
            this.elementStack.push(qName);
            if (qName.equalsIgnoreCase("METHOD")) {
                String id = attributes.getValue("id");
                String method = attributes.getValue("name");
                if ("setVersionProperty".equals(id)) {
                    this.setVersionProperty = true;
                } else if ("requestApplicationProcess".equals(id) && "POST".equalsIgnoreCase(method)) {
                    UDRestClient.this.features.add("REQUEST_APPLICATION_PROCESS_POST");
                }
            } else if (this.setVersionProperty && qName.equalsIgnoreCase("TEMPLATE") && "DOC".equalsIgnoreCase(parent)) {
                UDRestClient.this.features.add("SECURE_PROP_TRANSFER");
            } else if (qName.equalsIgnoreCase("feature") && ((String)(iter = this.elementStack.iterator()).next()).equalsIgnoreCase("application") && ((String)iter.next()).equalsIgnoreCase("doc") && ((String)iter.next()).equalsIgnoreCase("features")) {
                UDRestClient.this.features.add(attributes.getValue("name"));
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equalsIgnoreCase("METHOD")) {
                this.setVersionProperty = false;
            }
            this.elementStack.pop();
        }
    };

    public static DefaultHttpClient createHttpClient(String user, String password) {
        String verifyServerIdentityString = System.getenv().get("UC_TLS_VERIFY_CERTS");
        Boolean verifiedCerts = Boolean.valueOf(verifyServerIdentityString);
        return UDRestClient.createHttpClient(user, password, verifiedCerts == false);
    }

    public static DefaultHttpClient createHttpClient(String user, String password, boolean trustAllCerts) {
        HttpClientBuilder builder = new HttpClientBuilder();
        builder.setPreemptiveAuthentication(true);
        builder.setUsername(user);
        builder.setPassword(password);
        builder.setTrustAllCerts(trustAllCerts);
        if (!StringUtils.isEmpty(System.getenv("PROXY_HOST")) && StringUtils.isNumeric(System.getenv("PROXY_PORT"))) {
            log.debug("Configuring proxy settings.");
            builder.setProxyHost(System.getenv("PROXY_HOST"));
            builder.setProxyPort(Integer.valueOf(System.getenv("PROXY_PORT")));
        }
        if (!StringUtils.isEmpty(System.getenv("PROXY_USERNAME")) && !StringUtils.isEmpty(System.getenv("PROXY_PASSWORD"))) {
            log.debug("Configuring proxy settings.");
            builder.setProxyUsername(System.getenv("PROXY_USERNAME"));
            builder.setProxyPassword(System.getenv("PROXY_PASSWORD"));
        }
        return builder.buildClient();
    }

    public UDRestClient(URI url, String clientUser, String clientPassword) {
        this.url = url;
        this.clientUser = clientUser;
        this.clientPassword = clientPassword;
        this.client = UDRestClient.createHttpClient(clientUser, clientPassword);
    }

    public UDRestClient(URI url, String clientUser, String clientPassword, boolean trustAllCerts) {
        this.url = url;
        this.clientUser = clientUser;
        this.clientPassword = clientPassword;
        this.client = UDRestClient.createHttpClient(clientUser, clientPassword, trustAllCerts);
    }

    public UDRestClient(URI url, DefaultHttpClient client) {
        Check.nonNull(url);
        Check.nonNull(client);
        this.url = url;
        this.client = client;
        this.clientUser = null;
        this.clientPassword = null;
    }

    protected JSONObject createNewPropertyJSON(String name, String value, boolean isSecure) throws JSONException {
        JSONObject result = new JSONObject();
        result.put("name", name).put("value", value).put("secure", isSecure);
        return result;
    }

    protected JSONObject convertPropArrayToKeyValuePairs(JSONArray propArray) throws JSONException {
        JSONObject result = new JSONObject();
        for (int i = 0; i < propArray.length(); ++i) {
            JSONObject prop = propArray.getJSONObject(i);
            JSONObject propDefJSON = null;
            try {
                propDefJSON = (JSONObject)prop.get("propValue");
            }
            catch (JSONException e) {
                propDefJSON = (JSONObject)prop.get("propDef");
            }
            String propKey = (String)propDefJSON.get("name");
            String propValue = (String)propDefJSON.get("value");
            result.put(propKey, propValue);
        }
        return result;
    }

    protected StringEntity getStringEntity(Object object) {
        return new StringEntity(object.toString(), "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getBody(CloseableHttpResponse response) throws IOException {
        String result = null;
        StringBuilder builder = new StringBuilder();
        if (response.getStatusLine().getStatusCode() != 204) {
            InputStream body = response.getEntity().getContent();
            if (body != null) {
                InputStreamReader reader = IO.reader(body, IO.utf8());
                try {
                    IO.copy((Reader)reader, builder);
                }
                finally {
                    ((Reader)reader).close();
                }
            }
            result = builder.toString();
        }
        return result;
    }

    protected void discardBody(CloseableHttpResponse response) throws IOException {
        EntityUtils.consumeQuietly(response.getEntity());
    }

    protected CloseableHttpResponse invokeMethod(HttpRequestBase request) throws IOException, ClientProtocolException {
        CloseableHttpResponse response = this.client.execute(request);
        int status = response.getStatusLine().getStatusCode();
        if (status > 299) {
            throw new IOException(String.format("%d %s\n%s", response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), this.getBody(response)));
        }
        return response;
    }

    protected CloseableHttpResponse retryInvokeMethod(HttpRequestBase request, String logMethodName) throws IOException {
        int tryCount = 0;
        int status = 0;
        CloseableHttpResponse response = null;
        while ((status = (response = this.client.execute(request)).getStatusLine().getStatusCode()) == 409) {
            if (++tryCount > 10) {
                if (logMethodName != null) {
                    System.out.println("Reached retry limit");
                }
                throw new IOException(String.format("%d %s\n%s", response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), this.getBody(response)));
            }
            try {
                long wait = this.getNextBackoff(tryCount);
                if (logMethodName != null) {
                    System.out.println(String.format("Retrying %s after %dms (%d)", logMethodName, wait, tryCount));
                }
                this.sleep(wait);
            }
            catch (InterruptedException e1) {
                System.out.println(e1);
            }
        }
        if (status > 299) {
            throw new IOException(String.format("%d %s\n%s", response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), this.getBody(response)));
        }
        return response;
    }

    public int getNextBackoff(int attemptNum) {
        int max = (int)(200.0 * Math.pow(2.0, attemptNum));
        max = Math.min(max, 30000);
        int result = new Random().nextInt(max);
        return result;
    }

    protected void releaseConnection(HttpRequestBase request) {
        request.releaseConnection();
    }

    protected String encodePath(String path) {
        String result;
        try {
            result = this.sanitizePathSegment(path);
        }
        catch (Exception e) {
            log.debug("the user input " + path + " could not be sanitized. defaulting to user input", e);
            result = path;
        }
        return result;
    }

    protected String sanitizePathSegment(String path) throws URISyntaxException, EncoderException {
        PercentCodec encoder = new PercentCodec();
        return encoder.encode(path);
    }

    public Map<String, String> getJSONAsProperties(JSONObject object) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            Iterator iterator = object.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                Object value = object.get(key);
                if (value instanceof JSONObject || value instanceof JSONArray) continue;
                result.put(key, String.valueOf(value));
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("Failed to convert from JSON to map", e);
        }
        return result;
    }

    public boolean isSecurePropTransfer() {
        return this.getFeatures().contains("SECURE_PROP_TRANSFER");
    }

    public boolean isImportFinishedSupported() {
        return this.getFeatures().contains("IMPORT_FINISHED");
    }

    protected void sleep(long ms) throws InterruptedException {
        Thread.sleep(ms);
    }

    protected boolean isRequestApplicationProcessPost() {
        return this.getFeatures().contains("REQUEST_APPLICATION_PROCESS_POST");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getFeatures() {
        if (this.features == null) {
            this.features = new HashSet<String>();
            try {
                String body;
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser saxParser = factory.newSAXParser();
                HttpGet method = new HttpGet(this.url + "/cli/application.wadl");
                CloseableHttpResponse response = this.invokeMethod(method);
                try {
                    body = this.getBody(response);
                }
                finally {
                    response.close();
                }
                saxParser.parse(new InputSource(new StringReader(body)), this.handler);
            }
            catch (SAXException e) {
                throw new RuntimeException("Failed to parse the application.wadl.", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to find the application.wadl.", e);
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException("Found major configuration error before parsing the application.wadl.", e);
            }
        }
        return this.features;
    }
}

