/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.crypto;

import com.urbancode.commons.util.crypto.FIPSHelper;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class SecureRandomHelper {
    private static String FIPS_SECURE_RANDOM_ALG = "FIPSPRNG";
    private static String SHA1_SECURE_RANDOM_ALG = "SHA1PRNG";
    private static volatile SecureRandom secureRandom;

    @Deprecated
    public static String getSecureRandomAlg() {
        String result = FIPSHelper.isFipsRequested() ? FIPS_SECURE_RANDOM_ALG : SHA1_SECURE_RANDOM_ALG;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SecureRandom getSecureRandom() {
        SecureRandom r = secureRandom;
        if (r != null) return r;
        Class<SecureRandomHelper> clazz = SecureRandomHelper.class;
        synchronized (SecureRandomHelper.class) {
            r = secureRandom;
            if (r != null) return r;
            secureRandom = r = SecureRandomHelper.createNewSecureRandom();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return r;
        }
    }

    public static SecureRandom createNewSecureRandom() {
        if (!SecureRandomHelper.isUsingDefaultGenerator()) {
            FIPSHelper.enableFips();
            String algorithm = FIPS_SECURE_RANDOM_ALG;
            try {
                return SecureRandom.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Could not find secure random algorithm: " + algorithm, e);
            }
        }
        return new SecureRandom();
    }

    public static boolean isUsingDefaultGenerator() {
        return !FIPSHelper.isFipsRequested();
    }

    private SecureRandomHelper() {
    }
}

