/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.controller;

import com.urbancode.commons.profiler.Profiler;
import com.urbancode.commons.util.StringUtil;
import com.urbancode.commons.web.WebConfig;
import com.urbancode.commons.web.controller.Ajax;
import com.urbancode.commons.web.controller.DynamicResponse;
import com.urbancode.commons.web.controller.NoSuchDestinationException;
import com.urbancode.commons.web.controller.Trailable;
import com.urbancode.commons.web.util.RequestUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerServlet
extends HttpServlet {
    public static final String JSP = ".jsp";
    public static final String SLASH = "/";
    public static final String PACKAGE_SEPARATOR = ".";
    public static final String PARENT_PAGE_ID = "parentPageId";
    public static final String CURRENT_PAGE_ID = "currentPageId";
    public static final Class<?>[] REQUIRED_PARAM_TYPES = new Class[]{HttpServletRequest.class, HttpServletResponse.class};
    private static final long serialVersionUID = 1L;
    private static final String PACKAGE_PREFIX = WebConfig.getInstance().getTaskPackagePrefix();
    private static final Logger log = Logger.getLogger(ControllerServlet.class);

    public static String classUrl(Class<?> cls) {
        if (cls == null) {
            throw new NullPointerException("cls is null");
        }
        String clsName = cls.getName();
        if (!clsName.startsWith(PACKAGE_PREFIX)) {
            throw new IllegalArgumentException("cls package does not begin with" + PACKAGE_PREFIX);
        }
        int length = PACKAGE_PREFIX.length();
        if (PACKAGE_PREFIX.endsWith(PACKAGE_SEPARATOR)) {
            --length;
        }
        return "/tasks" + clsName.substring(length).replace('.', '/');
    }

    public static String classMethodUrl(Class<?> cls, String methodName) {
        return ControllerServlet.classMethodUrl(cls, methodName, true);
    }

    public static String classMethodUrl(Class<?> cls, String methodName, boolean logErrors) {
        String result;
        block3: {
            result = ControllerServlet.classUrl(cls) + SLASH + methodName;
            try {
                Method method = cls.getMethod(methodName, REQUIRED_PARAM_TYPES);
                if (!method.getReturnType().equals(DynamicResponse.class) || !Modifier.isPublic(method.getModifiers())) {
                    result = null;
                }
            }
            catch (NoSuchMethodException e) {
                result = null;
                if (!logErrors) break block3;
                log.warn("Can not create url " + e);
                log.trace("Can not create url " + e, e);
            }
        }
        return result;
    }

    public static String classJspUrl(Class<?> cls) {
        if (cls == null) {
            throw new NullPointerException("cls is null");
        }
        String clsName = cls.getName();
        if (!clsName.startsWith(PACKAGE_PREFIX)) {
            throw new IllegalArgumentException("cls package does not begin with" + PACKAGE_PREFIX);
        }
        String url = clsName.substring(PACKAGE_PREFIX.length());
        int i = url.lastIndexOf(46);
        url = i != -1 ? url.substring(0, i) : "";
        url = "/WEB-INF/jsps/" + url.replace('.', '/');
        return url;
    }

    public static String classJspUrl(Class<?> cls, String jsp) {
        String jspUrl = ControllerServlet.classJspUrl(cls) + SLASH + jsp + JSP;
        return jspUrl;
    }

    public static boolean isUrlClassMethod(Class<?> cls, String url) {
        boolean result = false;
        int idx = url.lastIndexOf(SLASH);
        String methodName = url.substring(idx + 1);
        String classMethodUrl = ControllerServlet.classMethodUrl(cls, methodName, false);
        if (classMethodUrl != null && url.endsWith(classMethodUrl)) {
            result = true;
        }
        return result;
    }

    public static String extractClassName(String pathInfo) {
        String[] split = pathInfo.split(SLASH);
        String[] classOnlySplit = new String[split.length - 2];
        System.arraycopy(split, 1, classOnlySplit, 0, classOnlySplit.length);
        String className = PACKAGE_PREFIX + (PACKAGE_PREFIX.endsWith(PACKAGE_SEPARATOR) ? "" : PACKAGE_SEPARATOR) + (classOnlySplit.length == 1 ? classOnlySplit[0] : StringUtil.join(classOnlySplit, PACKAGE_SEPARATOR));
        return className;
    }

    public static String extractMethodName(String pathInfo) {
        String[] split = pathInfo.split(SLASH);
        return split[split.length - 1];
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String className = null;
        String methodName = null;
        try {
            Object obj;
            Method method;
            Class<?> cls;
            String pathInfo = request.getPathInfo();
            if (pathInfo == null) {
                pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
            }
            String fullPath = request.getContextPath() + request.getServletPath() + pathInfo;
            if (log.isDebugEnabled()) {
                log.debug("path: " + fullPath);
            }
            int idx = pathInfo.lastIndexOf(SLASH);
            if (pathInfo.length() < 3 || idx < 2) {
                if (log.isDebugEnabled()) {
                    log.debug("Insane pathInfo " + pathInfo);
                }
                throw new NoSuchDestinationException(fullPath);
            }
            className = ControllerServlet.extractClassName(pathInfo);
            methodName = ControllerServlet.extractMethodName(pathInfo);
            try {
                cls = Class.forName(className);
                if (cls.getAnnotation(Deprecated.class) != null) {
                    log.warn("Class " + cls.getName() + " is Deprecated");
                }
            }
            catch (ClassNotFoundException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Unable to find class " + className);
                }
                throw new NoSuchDestinationException(fullPath, e);
            }
            try {
                method = cls.getMethod(methodName, REQUIRED_PARAM_TYPES);
            }
            catch (NoSuchMethodException e) {
                if (log.isDebugEnabled()) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("Method ").append(methodName).append("(");
                    int i = 0;
                    for (Class<?> paramType : REQUIRED_PARAM_TYPES) {
                        if (i > 0) {
                            msg.append(",");
                        }
                        msg.append(paramType.getName());
                        ++i;
                    }
                    msg.append(") does not exist for class '");
                    msg.append(cls.getName() + "'.");
                    log.debug(msg.toString());
                }
                throw new NoSuchDestinationException(fullPath, e);
            }
            if (!method.getReturnType().equals(DynamicResponse.class)) {
                if (log.isDebugEnabled()) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("Method ").append(methodName).append("(");
                    int i = 0;
                    for (Class<?> paramType : REQUIRED_PARAM_TYPES) {
                        if (i > 0) {
                            msg.append(",");
                        }
                        msg.append(paramType.getName());
                        ++i;
                    }
                    msg.append(") for class '").append(cls.getName()).append("' ");
                    msg.append("has inappropriate return type '");
                    msg.append(method.getReturnType().getName()).append("' when type '");
                    msg.append(DynamicResponse.class.getName()).append("' was expected.");
                    log.debug(msg.toString());
                }
                throw new NoSuchDestinationException(fullPath);
            }
            if (!Modifier.isPublic(method.getModifiers())) {
                if (log.isDebugEnabled()) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("Method ").append(methodName).append("(");
                    int i = 0;
                    for (Class<?> paramType : REQUIRED_PARAM_TYPES) {
                        if (i > 0) {
                            msg.append(",");
                        }
                        msg.append(paramType.getName());
                        ++i;
                    }
                    msg.append(") for class '").append(cls.getName()).append("' is not public.");
                    log.debug(msg.toString());
                }
                throw new NoSuchDestinationException(fullPath);
            }
            if (method.getAnnotation(Deprecated.class) != null) {
                StringBuilder msg = new StringBuilder();
                msg.append("Method ").append(methodName).append("(");
                int i = 0;
                for (Class<?> paramType : REQUIRED_PARAM_TYPES) {
                    if (i > 0) {
                        msg.append(",");
                    }
                    msg.append(paramType.getName());
                    ++i;
                }
                msg.append(") for class '").append(cls.getName()).append("'");
                log.warn("Using Deprecated Task: " + msg.toString());
            }
            try {
                obj = cls.newInstance();
            }
            catch (InstantiationException e) {
                throw new NoSuchDestinationException(fullPath);
            }
            if (log.isTraceEnabled()) {
                log.trace("At " + pathInfo);
            }
            String activityName = Profiler.getInstance().startActivity("GET " + className + PACKAGE_SEPARATOR + methodName);
            DynamicResponse result = (DynamicResponse)method.invoke(obj, request, response);
            if (obj instanceof Trailable && method.getAnnotation(Ajax.class) == null) {
                try {
                    request.setAttribute("UIPath", ((Trailable)obj).getPath(request));
                }
                catch (Exception e) {
                    log.error("Could not create Path Trail" + e.toString(), e);
                }
            }
            if (result != null) {
                RequestUtil.setPreviousRequestedUrl(request);
                result.respond(request, response);
            }
            if (log.isDebugEnabled()) {
                log.debug("response sent");
            }
            Profiler.getInstance().stopActivity(activityName);
        }
        catch (ServletException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new ServletException(e.getTargetException());
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }
}

