/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class ObjectPool {
    protected static final Logger log = Logger.getLogger(ObjectPool.class);
    public static final int NOLIMIT = -1;
    private static String className = ObjectPool.class.getName();
    private static int MIN_OBJECT_COUNT = Integer.getInteger(className + ".MIN_OBJECT_COUNT", 1);
    private static int MAX_OBJECT_COUNT = Integer.getInteger(className + ".MAX_OBJECT_COUNT", -1);
    private static int EXPIRATION_TIME = Integer.getInteger(className + ".EXPIRATION_TIME", 300);
    private static int CLEAN_UP_INTERVAL = Integer.getInteger(className + ".CLEAN_UP_INTERVAL", 300);
    private List<Object> ciObjectList = new LinkedList<Object>();
    protected Set<Object> coObjectSet = new HashSet<Object>();
    private int objectCount = 0;
    private int minObjectCount = MIN_OBJECT_COUNT;
    private int maxObjectCount = MAX_OBJECT_COUNT;
    private long expirationTime = EXPIRATION_TIME;
    private long cleanUpInterval = CLEAN_UP_INTERVAL;
    private boolean initialized = false;
    private boolean isShutdown = false;

    public ObjectPool() {
    }

    public ObjectPool(int minObjectCount, int maxObjectCount, int cleanUpInterval, int expirationTime) {
        if (minObjectCount >= 0) {
            this.minObjectCount = minObjectCount;
        }
        if (maxObjectCount != 0) {
            this.maxObjectCount = maxObjectCount;
        }
        if (cleanUpInterval > 0) {
            this.cleanUpInterval = cleanUpInterval;
        }
        if (expirationTime > 0) {
            this.expirationTime = expirationTime;
        }
    }

    public synchronized void start() {
        if (this.initialized) {
            throw new IllegalStateException("The ObjectPool has already been initialized.");
        }
        Object o = null;
        Saddle s = null;
        for (int i = 0; i < this.minObjectCount; ++i) {
            o = this.myGetNewInstance();
            s = new Saddle(o);
            this.ciObjectList.add(s);
        }
        CleanUpThread cleaner = new CleanUpThread();
        cleaner.start();
        this.initialized = true;
    }

    public synchronized boolean isInitialized() {
        return this.initialized;
    }

    public synchronized int getMinObjectCount() {
        if (!this.initialized) {
            throw new IllegalStateException("The ObjectPool has not been initialized.");
        }
        return this.minObjectCount;
    }

    public synchronized int getMaxObjectCount() {
        if (!this.initialized) {
            throw new IllegalStateException("The ObjectPool has not been initialized.");
        }
        return this.maxObjectCount;
    }

    public synchronized int getObjectCount() {
        if (!this.initialized) {
            throw new IllegalStateException("The ObjectPool has not been initialized.");
        }
        return this.objectCount;
    }

    public synchronized int getCheckedOutObjectCount() {
        if (!this.initialized) {
            throw new IllegalStateException("The ObjectPool has not been initialized.");
        }
        return this.coObjectSet.size();
    }

    public synchronized int getAvailableObjectCount() {
        if (!this.initialized) {
            throw new IllegalStateException("The ObjectPool has not been initialized.");
        }
        return this.ciObjectList.size();
    }

    public synchronized boolean isAtMaxSize() {
        if (!this.initialized) {
            throw new IllegalStateException("The ObjectPool has not been initialized.");
        }
        if (this.maxObjectCount == -1) {
            return false;
        }
        return this.objectCount >= this.maxObjectCount;
    }

    public synchronized int getCleanUpInterval() {
        if (!this.initialized) {
            throw new IllegalStateException("The ObjectPool has not been initialized.");
        }
        return (int)(this.cleanUpInterval / 1000L);
    }

    public synchronized int getExpirationTime() {
        if (!this.initialized) {
            throw new IllegalStateException("The ObjectPool has not been initialized.");
        }
        return (int)(this.expirationTime / 1000L);
    }

    public synchronized void shutdown() {
        log.debug((Object)("coObjectSet: " + this.coObjectSet));
        log.debug((Object)("ciObjectList: " + this.ciObjectList));
        if (!this.initialized) {
            throw new IllegalStateException("The ObjectPool has not been initialized.");
        }
        if (!this.isShutdown) {
            this.isShutdown = true;
            while (!this.ciObjectList.isEmpty()) {
                Saddle s = (Saddle)this.ciObjectList.remove(0);
                try {
                    this.myExpire(s.getRider());
                }
                catch (Throwable throwable) {}
            }
            this.notify();
        }
    }

    public synchronized boolean isShutdown() {
        if (!this.initialized) {
            throw new IllegalStateException("The ObjectPool has not been initialized.");
        }
        return this.isShutdown;
    }

    public synchronized Object checkOut() {
        if (!this.initialized) {
            throw new IllegalStateException("The ObjectPool has not been initialized.");
        }
        if (this.isShutdown) {
            throw new IllegalStateException("The ObjectPool has been shutdown.");
        }
        Saddle saddle = null;
        Object o = null;
        log.debug((Object)("ObjectPool: " + this));
        while (this.ciObjectList.isEmpty() && this.isAtMaxSize() && !this.isShutdown) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        if (this.isShutdown) {
            throw new IllegalStateException("The ObjectPool has been shutdown.");
        }
        if (!this.ciObjectList.isEmpty() && !this.myIsObjectValid(o = (saddle = (Saddle)this.ciObjectList.remove(0)).getRider())) {
            this.myExpire(o);
            o = null;
        }
        if (o == null && !this.isAtMaxSize() && !this.isShutdown) {
            o = this.myGetNewInstance();
        }
        if (o != null) {
            this.coObjectSet.add(o);
        }
        return o;
    }

    public synchronized void checkIn(Object o) {
        if (!this.initialized) {
            throw new IllegalStateException("The ObjectPool has not been initialized.");
        }
        if (!this.coObjectSet.contains(o)) {
            throw new IllegalArgumentException("The specified object does not belong to this ObjectPool.");
        }
        if (!this.isShutdown) {
            Saddle s = new Saddle(o);
            this.coObjectSet.remove(o);
            this.ciObjectList.add(s);
            this.notifyAll();
        } else {
            try {
                this.myExpire(o);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected synchronized void cleanUp() {
        long now = System.currentTimeMillis();
        int index = 0;
        while (index < this.ciObjectList.size() && this.ciObjectList.size() > this.getMinObjectCount()) {
            Saddle saddle = (Saddle)this.ciObjectList.get(index);
            if (now - saddle.getCreationTime() >= this.expirationTime * 1000L) {
                try {
                    this.myExpire(saddle.getRider());
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                this.ciObjectList.remove(index);
                saddle = null;
                continue;
            }
            ++index;
        }
        this.notifyAll();
    }

    protected final void myExpire(Object o) {
        --this.objectCount;
        try {
            this.expire(o);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    protected void expire(Object o) throws Exception {
    }

    protected final Object myGetNewInstance() {
        Object o = this.getNewInstance();
        if (o != null) {
            ++this.objectCount;
        }
        return o;
    }

    protected abstract Object getNewInstance();

    protected final boolean myIsObjectValid(Object o) {
        boolean valid = false;
        try {
            valid = this.isObjectValid(o);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return valid;
    }

    protected boolean isObjectValid(Object o) throws Exception {
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[ObjectPool: isInitialized=").append(this.initialized);
        sb.append(", isShutdown=").append(this.isShutdown);
        sb.append(", minObjCount=").append(this.minObjectCount);
        sb.append(", maxObjectCount=").append(this.maxObjectCount);
        sb.append(", objectCount=").append(this.objectCount);
        sb.append(", checkedOutCount=").append(this.coObjectSet.size());
        sb.append(", checkedInCount=").append(this.ciObjectList.size());
        sb.append(", objectCount=").append(this.objectCount);
        sb.append(", expirationTime=").append(this.expirationTime);
        sb.append(", cleanUpInterval=").append(this.cleanUpInterval);
        sb.append("]");
        return sb.toString();
    }

    class CleanUpThread
    extends Thread {
        CleanUpThread() {
            this.setPriority(1);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (!ObjectPool.this.isShutdown()) {
                try {
                    CleanUpThread.sleep(ObjectPool.this.cleanUpInterval * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ObjectPool.this.cleanUp();
            }
        }
    }

    static class Saddle {
        private Object rider;
        private long creationTime;

        Saddle(Object rider) {
            this.rider = rider;
            this.creationTime = System.currentTimeMillis();
        }

        Object getRider() {
            return this.rider;
        }

        long getCreationTime() {
            return this.creationTime;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Saddle)) {
                return false;
            }
            Saddle s = (Saddle)o;
            return this.rider.equals(s.rider);
        }

        public int hashCode() {
            return this.rider.hashCode();
        }

        public String toString() {
            return String.valueOf(this.rider);
        }
    }
}

