/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util;

import com.urbancode.commons.util.ObjectUtil;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class SynchronizedDateFormat
implements Serializable {
    private static final long serialVersionUID = 7460451663422561855L;
    private SimpleDateFormat format;
    private String pattern;

    public static synchronized SynchronizedDateFormat getInstance(String pattern) {
        return new SynchronizedDateFormat(pattern, TimeZone.getDefault());
    }

    public static synchronized SynchronizedDateFormat getInstance(String pattern, TimeZone timeZone) {
        return new SynchronizedDateFormat(pattern, timeZone);
    }

    private SynchronizedDateFormat(String pattern, TimeZone timeZone) {
        this.format = new SimpleDateFormat(pattern);
        this.format.setTimeZone(timeZone);
        this.pattern = pattern;
    }

    public synchronized String format(Date d) {
        return this.format.format(d);
    }

    public synchronized Date parse(String s) throws ParseException {
        return this.format.parse(s);
    }

    public String toPattern() {
        return this.pattern;
    }

    public int hashCode() {
        return (this.format == null ? 17 : this.format.hashCode()) * 17 + (this.pattern == null ? 5 : this.pattern.hashCode()) * 5;
    }

    public boolean equals(Object object) {
        boolean equals = false;
        if (object != null && object instanceof SynchronizedDateFormat) {
            SynchronizedDateFormat syncformat = (SynchronizedDateFormat)object;
            equals = true;
            equals = ObjectUtil.isEqual(this.format, syncformat.format) && ObjectUtil.isEqual(this.pattern, syncformat.pattern);
        }
        return equals;
    }
}

