/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* UrbanCode Build
* UrbanCode Release
* AnthillPro
* (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
package com.urbancode.air.plugin.udeploy.processes

import com.urbancode.air.AirPluginTool
import com.urbancode.ud.client.ApplicationClient
import com.urbancode.ud.client.ComponentClient
import com.urbancode.ud.client.ProcessClient
import java.util.UUID
import java.net.URI
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;


public class ProcessHelper {
    def apTool
    def props = []
    def udUser
    def udPass
    def weburl
    ApplicationClient applicationClient
    ComponentClient componentClient
    ProcessClient processClient

    public ProcessHelper(def apToolIn) {
        apTool = apToolIn
        props = apTool.getStepProperties()
        udUser = apTool.getAuthTokenUsername()
        udPass = apTool.getAuthToken()
        weburl = System.getenv("AH_WEB_URL")
        
        applicationClient = new ApplicationClient(new URI(weburl), udUser, udPass)
        componentClient = new ComponentClient(new URI(weburl), udUser, udPass)
        processClient = new ProcessClient(new URI(weburl), udUser, udPass)

        com.urbancode.air.XTrustProvider.install()
    }

    public def setProcessRequestProperty() {
        def propertyName = props['propertyName']
        def propertyValue = props['propertyValue']
        def secureValue = props['secureValue']
        def processRequestId = props['processRequestId']
        
        def linkTitle = props['linkTitle']
        if (linkTitle) {
            propertyName = "link:"+linkTitle
            propertyValue = props['linkUrl']
        }

        if (!propertyName) {
            throw new IllegalArgumentException("No property name was specified")
        }
        if (!processRequestId) {
            throw new IllegalArgumentException("No process request ID was specified")
        }

        def isSecure = false;
        if (secureValue) {
            isSecure = true;
            propertyValue = secureValue;
        }
        
        if (propertyValue == "") {
            propertyValue = null;
        }
        
        if (propertyValue) {
            if (linkTitle) {
                println "Setting link \""+propertyName+"\" to \""+propertyValue+"\"...";
            }
            else {
                println "Setting request property \""+propertyName+"\" to \""+propertyValue+"\"...";
            }
        }
        else {
            if (linkTitle) {
                println "Clearing link \""+propertyName+"\"...";
            }
            else {
                println "Clearing request property \""+propertyName+"\"...";
            }
        }

        try {
            applicationClient.setApplicationProcessRequestProperty(processRequestId, propertyName,
                    propertyValue, isSecure);
            println "Successfully updated application process request "+processRequestId;
            return;
        }
        catch (IOException e) {
            // Swallow this for now, we're assuming this isn't for an application process request.
        }
        
        try {
            componentClient.setComponentProcessRequestProperty(processRequestId, propertyName,
                    propertyValue, isSecure);
            println "Successfully updated component process request "+processRequestId;
            return;
        }
        catch (IOException e) {
            // Swallow this for now, we're assuming this isn't for a component process request.
        }
        
        processClient.setProcessRequestProperty(processRequestId, propertyName,
                propertyValue, isSecure);
        println "Successfully updated process request "+processRequestId;
    }
}
