/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.fileutils.filelister;

import com.urbancode.commons.fileutils.filelister.FileListerBase;
import com.urbancode.commons.fileutils.filelister.FileListerFactory;
import com.urbancode.commons.fileutils.filelister.FileType;
import com.urbancode.commons.fileutils.filelister.PermissionReader;
import com.urbancode.commons.fileutils.filelister.TypedFile;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;

final class FileListerIncludeNonEmptyExclude
extends FileListerBase {
    static final FileListerFactory FACTORY = new FileListerFactory(){

        public FileListerIncludeNonEmptyExclude create(File base, FileFilter filter, PermissionReader permissionReader) throws IOException {
            return new FileListerIncludeNonEmptyExclude(base, filter, permissionReader);
        }

        public String implementationName() {
            return FileListerIncludeNonEmptyExclude.class.getName();
        }
    };

    FileListerIncludeNonEmptyExclude(File base, FileFilter filter, PermissionReader permissionReader) throws IOException {
        super(base, filter, permissionReader);
    }

    protected boolean includeInList(TypedFile file) {
        if (file.type() == FileType.REGULAR) {
            return true;
        }
        if (file.type() == FileType.SYMLINK) {
            return false;
        }
        String[] files = file.translate(this.base()).list();
        return files != null && files.length > 0;
    }

    protected TypedFile normalize(TypedFile file) {
        return file;
    }

    boolean isSymLinkAware() {
        return true;
    }
}

