/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.controller;

import com.urbancode.commons.web.controller.ControllerServletNGTasks;
import com.urbancode.commons.web.controller.DynamicResponse;
import com.urbancode.commons.web.controller.DynamicResponseException;
import com.urbancode.commons.web.controller.NoSuchDestinationException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerServletNG
extends HttpServlet {
    private static final long serialVersionUID = 3367486394602412984L;
    private static final Logger log = Logger.getLogger(ControllerServletNG.class);
    private static final String JSP = ".jsp";
    private static final String SLASH = "/";
    private static final String PACKAGE_SEPARATOR = ".";
    private static final Class<?>[] REQUIRED_PARAM_TYPES = new Class[]{HttpServletRequest.class, HttpServletResponse.class};
    protected static final String TASK_PACKAGE_PREFIX_PARAM = "TASK_PACKAGE_PREFIX";
    protected static final String TASK_URL_BASE_PARAM = "TASK_URL_BASE";
    protected static final String JSP_URL_BASE_PARAM = "JSP_URL_BASE";
    private String taskUrlBase = "/tasks";
    private String jspUrlBase = "/WEB-INF/jsps";
    private Set<String> taskPackages = new LinkedHashSet<String>();

    public void init(ServletConfig config) throws ServletException {
        String jspUrlBase;
        super.init(config);
        String packagePrefix = config.getInitParameter(TASK_PACKAGE_PREFIX_PARAM);
        if (StringUtils.isNotEmpty(packagePrefix)) {
            this.taskPackages.clear();
            Collections.addAll(this.taskPackages, packagePrefix.split("[:;]"));
            this.taskPackages.remove("");
        }
        Validate.notEmpty(this.taskPackages, "One or more Task packages must be specified");
        String taskUrlBase = config.getInitParameter(TASK_URL_BASE_PARAM);
        if (StringUtils.isNotEmpty(taskUrlBase)) {
            this.taskUrlBase = taskUrlBase.replaceAll("/+$", "");
        }
        if (StringUtils.isNotEmpty(jspUrlBase = config.getInitParameter(JSP_URL_BASE_PARAM))) {
            this.jspUrlBase = jspUrlBase.replaceAll("/+$", "");
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block30: {
            try {
                Method method;
                String pathInfo = request.getPathInfo();
                if (pathInfo == null) {
                    pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
                }
                String fullPath = request.getContextPath() + request.getServletPath() + pathInfo;
                log.debug("path: " + fullPath);
                int idx = pathInfo.lastIndexOf(SLASH);
                if (pathInfo.length() < 3 || idx < 2) {
                    log.debug("Insane pathInfo " + pathInfo);
                    throw new NoSuchDestinationException(fullPath);
                }
                String relativeClassName = this.extractRelativeClassName(pathInfo);
                String methodName = this.extractMethodName(pathInfo);
                log.debug("REQUESTING: " + relativeClassName + " - " + methodName);
                Class<ControllerServletNGTasks> cls = null;
                for (String pack : this.taskPackages) {
                    try {
                        cls = Class.forName(pack + PACKAGE_SEPARATOR + relativeClassName).asSubclass(ControllerServletNGTasks.class);
                        break;
                    }
                    catch (ClassNotFoundException e) {
                        log.trace("Unable to find class " + relativeClassName);
                    }
                }
                if (cls == null) {
                    log.debug("Unable to find class " + relativeClassName);
                    throw new NoSuchDestinationException(fullPath);
                }
                try {
                    method = cls.getMethod(methodName, REQUIRED_PARAM_TYPES);
                }
                catch (NoSuchMethodException e) {
                    log.debug("Method " + methodName + "(HttpServletRequest, HttpServletResponse) does not exist " + "for class " + cls.getName());
                    throw new NoSuchDestinationException(fullPath, e);
                }
                if (cls.isAnnotationPresent(Deprecated.class) || method.isAnnotationPresent(Deprecated.class)) {
                    log.warn("Accessing deprecated url " + pathInfo);
                }
                if (!DynamicResponse.class.isAssignableFrom(method.getReturnType())) {
                    log.debug("Method " + methodName + "(HttpServletRequest, HttpServletResponse) for class " + cls.getName() + " has inappropriate return type " + method.getReturnType().getName());
                    throw new NoSuchDestinationException(fullPath);
                }
                if (!Modifier.isPublic(method.getModifiers())) {
                    log.debug("Method " + methodName + "(HttpServletRequest, HttpServletResponse) for class " + cls.getName() + " is not public");
                    throw new NoSuchDestinationException(fullPath);
                }
                try {
                    ControllerServletNGTasks taskObject;
                    try {
                        taskObject = cls.newInstance();
                    }
                    catch (InstantiationException e) {
                        throw new NoSuchDestinationException(fullPath, e);
                    }
                    log.trace("At " + pathInfo);
                    taskObject.setControllerServlet(this);
                    DynamicResponse result = (DynamicResponse)method.invoke((Object)taskObject, request, response);
                    if (result != null) {
                        result.respond(request, response);
                    }
                    log.trace("response sent");
                }
                catch (DynamicResponseException dre) {
                    DynamicResponse dynamicResponse = dre.getResponse();
                    try {
                        dynamicResponse.respond(request, response);
                    }
                    catch (Exception e) {
                        log.error(e, e);
                    }
                }
                catch (IllegalAccessException e) {
                    response.setStatus(500);
                    throw new ServletException("Cannot access " + relativeClassName + PACKAGE_SEPARATOR + methodName + "()", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    log.error("Error occurred invoking " + relativeClassName + PACKAGE_SEPARATOR + methodName + "()");
                    Throwable cause = e.getCause();
                    if (cause == null) {
                        log.error(e.getMessage(), e);
                    }
                    if (cause instanceof DynamicResponseException) {
                        DynamicResponseException dre = (DynamicResponseException)cause;
                        DynamicResponse dynamicResponse = dre.getResponse();
                        try {
                            dynamicResponse.respond(request, response);
                        }
                        catch (Exception e1) {
                            log.error(e, e);
                        }
                        break block30;
                    }
                    if (cause instanceof NoSuchDestinationException) {
                        response.setStatus(404);
                    } else if (cause instanceof FileNotFoundException) {
                        response.setStatus(404);
                    } else {
                        response.setStatus(500);
                    }
                    log.error(cause.getMessage(), cause);
                    throw new ServletException(cause);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
                request.setAttribute("exception", (Object)e);
                throw new ServletException((Throwable)e);
            }
        }
    }

    private String extractRelativeClassName(String pathInfo) {
        int idx = pathInfo.lastIndexOf(SLASH);
        String path = pathInfo.substring(1, idx);
        return path.replaceAll(SLASH, PACKAGE_SEPARATOR);
    }

    private String extractMethodName(String pathInfo) {
        int idx = pathInfo.lastIndexOf(SLASH);
        return pathInfo.substring(idx + 1);
    }

    protected String classUrl(Class<? extends ControllerServletNGTasks> cls) {
        if (cls == null) {
            throw new NullPointerException("cls is null");
        }
        String clsName = cls.getName();
        String foundPrefix = null;
        for (String prefix : this.taskPackages) {
            if (!clsName.startsWith(prefix + PACKAGE_SEPARATOR)) continue;
            foundPrefix = prefix;
            break;
        }
        if (StringUtils.isEmpty(foundPrefix)) {
            throw new IllegalArgumentException("cls package does not belong to a task package");
        }
        String url = clsName.substring(foundPrefix.length());
        url = this.taskUrlBase + url.replace('.', '/');
        return url.replaceAll("/{2,}", SLASH);
    }

    protected String classMethodUrl(Class<? extends ControllerServletNGTasks> cls, String methodName) {
        return this.classMethodUrl(cls, methodName, true);
    }

    protected String classMethodUrl(Class<? extends ControllerServletNGTasks> cls, String methodName, boolean logErrors) {
        String result;
        block6: {
            result = (this.classUrl(cls) + SLASH + methodName).replaceAll("/{2,}", SLASH);
            try {
                Method method = cls.getMethod(methodName, REQUIRED_PARAM_TYPES);
                if (cls.isAnnotationPresent(Deprecated.class) || method.isAnnotationPresent(Deprecated.class)) {
                    log.warn("Creating deprecated url " + result);
                }
                if (!DynamicResponse.class.isAssignableFrom(method.getReturnType()) || !Modifier.isPublic(method.getModifiers())) {
                    result = null;
                }
            }
            catch (SecurityException e) {
                result = null;
                if (logErrors) {
                    log.warn("Can not create url " + e);
                    log.trace("Can not create url " + e, e);
                }
            }
            catch (NoSuchMethodException e) {
                result = null;
                if (!logErrors) break block6;
                log.warn("Can not create url " + e);
                log.trace("Can not create url " + e, e);
            }
        }
        return result;
    }

    protected String classJspUrl(Class<? extends ControllerServletNGTasks> cls) {
        if (cls == null) {
            throw new NullPointerException("cls is null");
        }
        String url = this.classUrl(cls);
        return url.replaceFirst("^" + Pattern.quote(this.taskUrlBase), Matcher.quoteReplacement(this.jspUrlBase));
    }

    protected String classJspUrl(Class<? extends ControllerServletNGTasks> cls, String jsp) {
        return this.classJspUrl(cls) + SLASH + jsp + JSP;
    }

    protected boolean isUrlClassMethod(Class<? extends ControllerServletNGTasks> cls, String url) {
        boolean result = false;
        int idx = url.lastIndexOf(SLASH);
        String methodName = url.substring(idx + 1);
        String classMethodUrl = this.classMethodUrl(cls, methodName, false);
        if (classMethodUrl != null && url.endsWith(classMethodUrl)) {
            result = true;
        }
        return result;
    }
}

