/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* UrbanCode Build
* UrbanCode Release
* AnthillPro
* (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.udeploy.resources.ResourceHelper

def apTool = new AirPluginTool(this.args[0], this.args[1])
def properties = apTool.getStepProperties();

ResourceHelper helper = new ResourceHelper(apTool)

try {
    println "Beginning agent SSH installation..."
    helper.installAgent()
    println "SSH installation complete."

    if (properties['waitForOnline'] == "true") {
        println "\nWaiting for agent to come online..."
        helper.waitForAgents([properties['name']], 120)
    }
}
catch (IllegalArgumentException e) {
    println e.getMessage();
    System.exit(1);
}