/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.udeploy.system

import com.urbancode.air.AirPluginTool
import com.urbancode.ud.client.SystemClient
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class SystemHelper {
    def apTool
    def props = []
    def udUser
    def udPass
    def weburl
    SystemClient client
    
    public SystemHelper(def apToolIn) {
        apTool = apToolIn
        props = apTool.getStepProperties()
        udUser = apTool.getAuthTokenUsername()
        udPass = apTool.getAuthToken()
        weburl = System.getenv("AH_WEB_URL")
        client = new SystemClient(new URI(weburl), udUser, udPass)
        
        com.urbancode.air.XTrustProvider.install()
    }
    
    def setSystemProperty() {
        def propName = props['name']
        def propValue = props['value']
        def isSecure = Boolean.valueOf(props['isSecure'])
        
        if (!propName) {
            throw new IllegalArgumentException("no property name was specified")
        }
        if (!propValue) {
            propValue = ""
        }
        client.setSystemProperty(propName, propValue, isSecure)
        println "System property with name ${propName} was set."
        println "You may find it under Settings -> Properties."
    }
    
    def getSystemConfiguration() {
        def values = client.getSystemConfiguration()
        
        values.keys().each() { key ->
            apTool.setOutputProperty(key, values.optString(key))
        }
        println "System configuration acquired."
        println "It can be viewed in the output properties of this step."
        apTool.setOutputProperties()
    }
    
    def setSystemConfiguration() {
        def propertiesString = props['properties']
        def properties = new Properties()
        properties.load(new ByteArrayInputStream(propertiesString.getBytes()))
        
        def propertyMap = new HashMap<String, String>()
        for (def key : properties.keySet()) {
            def value = properties.get(key)
            propertyMap.put(key, value)
            
            println "Setting "+key+" to "+value
        }
        client.setSystemConfiguration(propertyMap)
        println "System configuration was set."
    }
    
    def addUserToTeam() {
        def user = props['user']
        def teamName = props['team']
        def typeName = props['type']
        
        if (!user) {
            throw new IllegalArgumentException("no user was specified")
        }
        if (!teamName) {
            throw new IllegalArgumentException("no team was specified")
        }
        if (!typeName) {
            throw new IllegalArgumentException("no type was specified")
        }

        client.addUserToTeam(user, teamName, typeName)
        println "User was added to team for the given type classification."
    }
    
    def addGroupToTeam() {
        def group = props['group']
        def teamName = props['team']
        def typeName = props['type']
        
        if (!group) {
            throw new IllegalArgumentException("no group was specified")
        }
        if (!teamName) {
            throw new IllegalArgumentException("no team was specified")
        }
        if (!typeName) {
            throw new IllegalArgumentException("no type was specified")
        }

        client.addGroupToTeam(group, teamName, typeName)
        println "Group was added to team for the given type classification."
    }
}