#!/usr/bin/env groovy
/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2011, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool;
import com.urbancode.ud.client.ComponentClient;

def apTool = new AirPluginTool(this.args[0], this.args[1]);

def props = apTool.getStepProperties();

def udUser = apTool.getAuthTokenUsername();
def udPass = apTool.getAuthToken();
def weburl = System.getenv("AH_WEB_URL");
def status = props['status'];
def componentName = props['componentName'];
def versionName = props['versionName'];

com.urbancode.air.XTrustProvider.install()

def udRestClient = new ComponentClient(new URI(weburl), udUser, udPass);

println "removing status $status from version $versionName on component $componentName";
udRestClient.removeComponentVersionStatus(componentName,
                                       versionName,
                                       status);
