#!/usr/bin/env groovy
/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* UrbanCode Build
* UrbanCode Release
* AnthillPro
* (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

import com.urbancode.air.AirPluginTool;
import com.urbancode.ud.client.ComponentClient;

def apTool = new AirPluginTool(this.args[0], this.args[1]);

def props = apTool.getStepProperties();

def udUser = apTool.getAuthTokenUsername();
def udPass = apTool.getAuthToken();
def weburl = System.getenv("AH_WEB_URL");
def componentName = props['componentName'];
def versionName = props['versionName'];
def linkTitle = props['linkTitle'];
def linkURL = props['linkURL'];

ComponentClient componentClient = new ComponentClient(new URI(weburl), udUser, udPass)

try{
    componentClient.addComponentVersionLink(componentName, versionName, linkTitle, linkURL)
    println "Link ${linkTitle} successfully added to the component version"

} catch (IOException e){
    println e.getMessage();
    println e.printStackTrace();
    System.exit 1
}

System.exit 0


