/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ds.client;

import com.urbancode.commons.util.IO;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

public class DownloadVersionFilesCommand {
    private final String baseUrl;
    private final String component;
    private final String version;
    private String location;
    private final String singleFilePath;
    private final HttpClient client;

    public DownloadVersionFilesCommand(String baseUrl, HttpClient client, String component, String version, String location, String singleFilePath) {
        this.baseUrl = baseUrl.replaceAll("/+$", "");
        this.component = component;
        this.version = version;
        this.client = client;
        this.location = location;
        this.singleFilePath = singleFilePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        System.out.print("[#         ]\r");
        String fileName = "";
        String url = this.getUrl("/downloadArtifacts", "version", this.version, "component", this.component, "location", this.location, "singleFilePath", this.singleFilePath);
        if (StringUtils.isEmpty((CharSequence)this.singleFilePath)) {
            if (!StringUtils.isEmpty((CharSequence)this.component)) {
                fileName = fileName + this.component + "_";
            }
            fileName = fileName + this.version + "_artifacts.zip";
        } else {
            fileName = this.singleFilePath;
            int i = this.singleFilePath.lastIndexOf(47);
            if (i >= 0) {
                fileName = this.singleFilePath.substring(i + 1);
            }
        }
        HttpGet method = new HttpGet(url);
        System.out.println("Downloading...");
        if (!StringUtils.isEmpty((CharSequence)this.location) && !this.location.endsWith(File.separator)) {
            this.location = this.location + File.separator;
        }
        String filePath = fileName;
        if (this.location != null) {
            filePath = this.location + fileName;
        }
        File download = new File(filePath);
        File parent = download.getParentFile();
        System.out.print("[##        ]\r");
        HttpResponse response = this.client.execute((HttpUriRequest)method);
        try {
            int code = response.getStatusLine().getStatusCode();
            if (code < 200 || code >= 300) {
                String message = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)IO.utf8());
                throw new Exception("Request error: " + code + ": " + message);
            }
            if (parent != null) {
                parent.mkdirs();
            }
            try (FileOutputStream fos = new FileOutputStream(download);
                 InputStream inputStream = response.getEntity().getContent();){
                System.out.print("[###       ]\r");
                IO.copy(inputStream, (OutputStream)fos);
                System.out.print("[######### ]\r");
                System.out.print("[##########]\n");
                System.out.println("Completed.\n\nDownloaded to " + download.getAbsolutePath());
            }
            System.out.println("Completed.\n\nDownloaded to " + download.getAbsolutePath());
        }
        finally {
            method.releaseConnection();
        }
    }

    private String getUrl(String path, Object ... parameters) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.baseUrl);
        sb.append("/cli/version");
        sb.append(path);
        if (parameters != null && parameters.length > 0) {
            sb.append('?');
            for (int i = 0; i < parameters.length; i += 2) {
                if (parameters[i + 1] == null) continue;
                sb.append(URLEncoder.encode(parameters[i].toString(), "UTF-8"));
                sb.append('=');
                sb.append(URLEncoder.encode(parameters[i + 1].toString(), "UTF-8"));
                sb.append('&');
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }
}

