/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.vfs.common;

import com.urbancode.vfs.common.Encoding;
import com.urbancode.vfs.common.Hash;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class EncodingUtil {
    protected static final char ESCAPE_CHAR = '%';
    protected static final int HEX_RADIX = 16;
    protected static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    public byte[] decode(Encoding encoding, String encodedValue) throws DecoderException {
        byte[] bytes;
        if (Encoding.Hex.equals((Object)encoding)) {
            bytes = Hex.decodeHex((char[])encodedValue.toCharArray());
        } else if (Encoding.Base64.equals((Object)encoding)) {
            bytes = Base64.decodeBase64((byte[])encodedValue.getBytes());
        } else {
            throw new IllegalArgumentException("Unrecognized Encoding: " + (Object)((Object)encoding));
        }
        return bytes;
    }

    public byte[] decode(Hash hash) throws DecoderException {
        return this.decode(hash.getEncoding(), hash.getValue());
    }

    public String encode(Encoding encoding, byte[] value) {
        String encodedValue;
        if (Encoding.Hex.equals((Object)encoding)) {
            encodedValue = new String(Hex.encodeHex((byte[])value));
        } else if (Encoding.Base64.equals((Object)encoding)) {
            encodedValue = new String(Base64.encodeBase64((byte[])value));
        } else {
            throw new IllegalArgumentException("Unrecognized Encoding: " + (Object)((Object)encoding));
        }
        return encodedValue;
    }

    public String percentEncode(String arg0) throws EncoderException {
        StringBuilder sb = new StringBuilder();
        int rangeStart = 0;
        boolean rangeDoEncode = false;
        for (int i = 0; i < arg0.length(); ++i) {
            boolean charDoEncode;
            char c = arg0.charAt(i);
            boolean bl = charDoEncode = !EncodingUtil.isUnreserved(c);
            if (charDoEncode == rangeDoEncode) continue;
            this.copy(arg0, rangeStart, i, rangeDoEncode, sb);
            rangeStart = i;
            rangeDoEncode = charDoEncode;
        }
        this.copy(arg0, rangeStart, arg0.length(), rangeDoEncode, sb);
        return sb.toString();
    }

    protected static boolean isUnreserved(char c) {
        if (c >= 'A' && c <= 'Z') {
            return true;
        }
        if (c >= 'a' && c <= 'z') {
            return true;
        }
        if (c >= '0' && c <= '9') {
            return true;
        }
        return c == '-' || c == '_' || c == '.' || c == '~';
    }

    private void copy(String str, int start, int end, boolean encode, StringBuilder out) throws EncoderException {
        String range = str.substring(start, end);
        if (!encode) {
            out.append(range);
        } else {
            ByteBuffer buffer;
            try {
                CharsetEncoder encoder = Charset.forName("UTF-8").newEncoder();
                buffer = encoder.encode(CharBuffer.wrap(range));
            }
            catch (CharacterCodingException e) {
                throw new EncoderException(e.toString(), (Throwable)e);
            }
            while (buffer.hasRemaining()) {
                byte b = buffer.get();
                out.append('%');
                int hi = b >>> 4 & 0xF;
                out.append(HEX_ARRAY[hi]);
                out.append(HEX_ARRAY[b & 0xF]);
            }
        }
    }
}

