/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ud.client;

import com.urbancode.commons.util.StringUtil;
import com.urbancode.ud.client.UDRestClient;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class EnvironmentClient
extends UDRestClient {
    public EnvironmentClient(URI url, String clientUser, String clientPassword) {
        super(url, clientUser, clientPassword);
    }

    public EnvironmentClient(URI url, String clientUser, String clientPassword, boolean trustAllCerts) {
        super(url, clientUser, clientPassword, trustAllCerts);
    }

    public EnvironmentClient(URI url, DefaultHttpClient client) {
        super(url, client);
    }

    public void addEnvironmentBaseResource(String application, String environment, String resource) throws IOException {
        String uri = this.url + "/cli/environment/addBaseResource?environment=" + this.encodePath(environment) + "&resource=" + this.encodePath(resource);
        if (!StringUtils.isEmpty((CharSequence)application)) {
            uri = uri + "&application=" + this.encodePath(application);
        }
        HttpPut method = new HttpPut(uri);
        this.invokeMethod((HttpRequestBase)method);
    }

    public void addEnvironmentToTeam(String application, String environment, String team, String type) throws IOException {
        String uri = this.url + "/cli/environment/teams?team=" + this.encodePath(team) + "&type=" + this.encodePath(type) + "&environment=" + this.encodePath(environment);
        if (!StringUtils.isEmpty((CharSequence)application)) {
            uri = uri + "&application=" + this.encodePath(application);
        }
        HttpPut method = new HttpPut(uri);
        this.invokeMethod((HttpRequestBase)method);
    }

    public UUID createEnvironment(String applicationName, String name, String description, String color, boolean requireApprovals, String blueprintName, String baseResource) throws IOException, JSONException {
        return this.createEnvironment(applicationName, name, description, color, requireApprovals, blueprintName, baseResource, null);
    }

    public UUID createEnvironment(String applicationName, String name, String description, String color, boolean requireApprovals, String blueprintName, String baseResource, String envProfileName) throws IOException, JSONException {
        return this.createEnvironment(applicationName, name, description, color, requireApprovals, blueprintName, baseResource, envProfileName, null);
    }

    public UUID createEnvironment(String applicationName, String name, String description, String color, boolean requireApprovals, String blueprintName, String baseResource, String envProfileName, JSONObject nodeProperties) throws IOException, JSONException {
        UUID result = null;
        if (StringUtils.isEmpty((CharSequence)blueprintName)) {
            String uri = this.url + "/cli/environment/createEnvironment?application=" + this.encodePath(applicationName) + "&name=" + this.encodePath(name) + "&description=" + this.encodePath(description) + "&color=" + this.encodePath(color) + "&requireApprovals=" + String.valueOf(requireApprovals);
            HttpPut method = new HttpPut(uri);
            CloseableHttpResponse response = this.invokeMethod((HttpRequestBase)method);
            String body = this.getBody(response);
            result = UUID.fromString(body);
        } else {
            JSONObject jsonToSend = new JSONObject();
            jsonToSend.put("name", (Object)name);
            jsonToSend.put("description", (Object)description);
            jsonToSend.put("application", (Object)applicationName);
            jsonToSend.put("blueprint", (Object)blueprintName);
            jsonToSend.put("baseResource", (Object)baseResource);
            jsonToSend.put("color", (Object)color);
            jsonToSend.put("requireApprovals", requireApprovals);
            if (!StringUtil.isEmpty((String)envProfileName)) {
                jsonToSend.put("envProfileName", (Object)envProfileName);
            }
            if (nodeProperties != null) {
                jsonToSend.put("nodeProperties", (Object)nodeProperties);
            }
            String uri = this.url + "/cli/environment/provisionEnvironment";
            HttpPut method = new HttpPut(uri);
            method.setEntity((HttpEntity)this.getStringEntity(jsonToSend));
            CloseableHttpResponse response = this.invokeMethod((HttpRequestBase)method);
            String body = this.getBody(response);
            JSONObject jsonBody = new JSONObject(body);
            result = UUID.fromString(jsonBody.getString("id"));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDesiredInventoryEntry(String deploymentRequest, String environmentId, String componentId, String versionId, String status) throws IOException, JSONException {
        String uri = this.url + "/rest/inventory/desiredInventory/entries";
        JSONObject entry = new JSONObject();
        entry.put("environmentId", (Object)environmentId);
        entry.put("componentId", (Object)componentId);
        entry.put("versionId", (Object)versionId);
        entry.put("status", (Object)status);
        JSONArray entries = new JSONArray();
        entries.put((Object)entry);
        JSONObject requestBody = new JSONObject();
        requestBody.put("deploymentRequest", (Object)deploymentRequest);
        requestBody.put("entries", (Object)entries);
        HttpPut method = new HttpPut(uri);
        try {
            method.setEntity((HttpEntity)this.getStringEntity(requestBody));
            this.invokeMethod((HttpRequestBase)method);
        }
        finally {
            this.releaseConnection((HttpRequestBase)method);
        }
    }

    public void deleteAllDesiredInventoryVersions(String environmentId, String componentId) throws IOException, JSONException {
        String uri = this.url + "/cli/environment/" + environmentId.toString() + "/versions/" + componentId.toString() + "?deleteVersions=true";
        HttpDelete method = new HttpDelete(uri);
        this.invokeMethod((HttpRequestBase)method);
    }

    public JSONObject createEnvironmentFromTemplate(String appId, String envName, String description, String templateId, String templateName) throws IOException, JSONException {
        JSONObject result = null;
        String uri = this.url + "/cli/environment/createEnvironmentFromTemplate";
        JSONObject envJson = new JSONObject();
        envJson.put("applicationId", (Object)appId);
        envJson.put("name", (Object)envName);
        if (!StringUtils.isEmpty((CharSequence)description)) {
            envJson.put("description", (Object)description);
        }
        if (!StringUtils.isEmpty((CharSequence)templateId)) {
            envJson.put("templateId", (Object)templateId);
        } else if (!StringUtils.isEmpty((CharSequence)templateName)) {
            envJson.put("templateName", (Object)templateName);
        } else {
            throw new RuntimeException("[Error] Either the environment templateId or templateName property must be specified.");
        }
        HttpPut method = new HttpPut(uri);
        method.setEntity((HttpEntity)this.getStringEntity(envJson));
        CloseableHttpResponse response = this.invokeMethod((HttpRequestBase)method);
        String body = this.getBody(response);
        result = new JSONObject(body);
        return result;
    }

    public void deleteEnvironment(String applicationName, String name) throws IOException {
        String uri = this.url + "/cli/environment/deleteEnvironment?environment=" + this.encodePath(name);
        if (!StringUtils.isEmpty((CharSequence)applicationName)) {
            uri = uri + "&application=" + this.encodePath(applicationName);
        }
        HttpDelete method = new HttpDelete(uri);
        this.invokeMethod((HttpRequestBase)method);
    }

    public Map<String, String> getComponentEnvironmentProperties(String compName, String envName, String appName) throws IOException, JSONException {
        HashMap<String, String> result = new HashMap<String, String>();
        if ("".equals(envName) || "".equals(appName)) {
            throw new IOException("a required argument was not supplied");
        }
        String uri = this.url + "/cli/environment/componentProperties?environment=" + this.encodePath(envName) + "&component=" + this.encodePath(compName);
        if (!StringUtils.isEmpty((CharSequence)appName)) {
            uri = uri + "&application=" + this.encodePath(appName);
        }
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod((HttpRequestBase)method);
        String body = this.getBody(response);
        JSONArray propsJSON = new JSONArray(body);
        for (int i = 0; i < propsJSON.length(); ++i) {
            JSONObject propObject = (JSONObject)propsJSON.get(i);
            result.put((String)propObject.get("name"), (String)propObject.get("value"));
        }
        return result;
    }

    public Map<String, String> getEnvironmentProperties(String envName, String appName) throws IOException, JSONException {
        HashMap<String, String> result = new HashMap<String, String>();
        if ("".equals(envName) || "".equals(appName)) {
            throw new IOException("a required argument was not supplied");
        }
        String uri = this.url + "/cli/environment/getProperties?environment=" + this.encodePath(envName);
        if (!StringUtils.isEmpty((CharSequence)appName)) {
            uri = uri + "&application=" + this.encodePath(appName);
        }
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod((HttpRequestBase)method);
        String body = this.getBody(response);
        JSONArray propsJSON = new JSONArray(body);
        for (int i = 0; i < propsJSON.length(); ++i) {
            JSONObject propObject = (JSONObject)propsJSON.get(i);
            result.put((String)propObject.get("name"), (String)propObject.get("value"));
        }
        return result;
    }

    public UUID getEnvironmentUUID(String environmentName, String applicationName) throws IOException, JSONException {
        UUID result = null;
        String uri = this.url + "/cli/environment/info?environment=" + this.encodePath(environmentName);
        if (applicationName != null && !"".equals(applicationName)) {
            uri = uri + "&application=" + this.encodePath(applicationName);
        }
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod((HttpRequestBase)method);
        String body = this.getBody(response);
        JSONObject resultJSON = new JSONObject(body);
        result = UUID.fromString(resultJSON.getString("id"));
        return result;
    }

    public JSONObject getEnvironment(String environmentName, String applicationName) throws IOException, JSONException {
        String uri = this.url + "/cli/environment/info?environment=" + this.encodePath(environmentName);
        if (applicationName != null && !"".equals(applicationName)) {
            uri = uri + "&application=" + this.encodePath(applicationName);
        }
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod((HttpRequestBase)method);
        String body = this.getBody(response);
        return new JSONObject(body);
    }

    public void removeEnvironmentBaseResource(String application, String environment, String resource) throws IOException {
        String uri = this.url + "/cli/environment/removeBaseResource?environment=" + this.encodePath(environment) + "&resource=" + this.encodePath(resource);
        if (!StringUtils.isEmpty((CharSequence)application)) {
            uri = uri + "&application=" + this.encodePath(application);
        }
        HttpPut method = new HttpPut(uri);
        this.invokeMethod((HttpRequestBase)method);
    }

    public String setComponentEnvironmentProperty(String componentName, String envName, String appName, String name, String value) throws IOException {
        return this.setComponentEnvironmentProperty(componentName, envName, appName, name, value, null);
    }

    public String setComponentEnvironmentProperty(String componentName, String envName, String appName, String name, String value, Boolean isSecure) throws IOException {
        if ("".equals(componentName) || "".equals(name) || "".equals(envName)) {
            throw new IOException("a required argument was not supplied");
        }
        String uri = this.url + "/cli/environment/componentProperties";
        HttpPut method = null;
        if (this.isSecurePropTransfer()) {
            JSONObject ent = new JSONObject();
            try {
                ent.put("component", (Object)componentName);
                ent.put("environment", (Object)envName);
                ent.put("name", (Object)name);
                ent.put("value", (Object)value);
                if (isSecure != null) {
                    ent.put("isSecure", (Object)isSecure);
                }
                if (appName != null && !"".equals(appName)) {
                    ent.put("application", (Object)appName);
                }
            }
            catch (JSONException e) {
                throw new IOException(e.getMessage(), e);
            }
            method = new HttpPut(uri);
            method.setEntity((HttpEntity)new StringEntity(ent.toString()));
        } else {
            uri = uri + "?component=" + this.encodePath(componentName) + "&environment=" + this.encodePath(envName) + "&name=" + this.encodePath(name) + "&value=" + this.encodePath(value) + "&isSecure=" + this.encodePath(String.valueOf(isSecure));
            if (appName != null && !"".equals(appName)) {
                uri = uri + "&application=" + this.encodePath(appName);
            }
            method = new HttpPut(uri);
        }
        this.retryInvokeMethod((HttpRequestBase)method, "set component environment property");
        String result = isSecure != null && isSecure != false ? name + "=****" : name + "=" + value;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setEnvironmentProperty(String envName, String appName, String name, String value, boolean isSecure) throws IOException {
        if ("".equals(envName) || "".equals(name)) {
            throw new IOException("a required argument was not supplied");
        }
        String uri = this.url + "/cli/environment/propValue";
        HttpPut method = null;
        if (this.isSecurePropTransfer()) {
            JSONObject entity = new JSONObject();
            try {
                entity.put("name", (Object)name);
                entity.put("environment", (Object)envName);
                entity.put("value", (Object)value);
                entity.put("isSecure", isSecure);
                if (!StringUtils.isEmpty((CharSequence)appName)) {
                    entity.put("application", (Object)appName);
                }
            }
            catch (JSONException e) {
                throw new IOException(e.getMessage(), e);
            }
            method = new HttpPut(uri);
            method.setEntity((HttpEntity)new StringEntity(entity.toString()));
        } else {
            uri = uri + "?environment=" + this.encodePath(envName) + "&name=" + this.encodePath(name) + "&value=" + this.encodePath(value) + "&isSecure=" + this.encodePath(String.valueOf(isSecure));
            if (!StringUtils.isEmpty((CharSequence)appName)) {
                uri = uri + "&application=" + this.encodePath(appName);
            }
            method = new HttpPut(uri);
        }
        try {
            this.retryInvokeMethod((HttpRequestBase)method, "set environment property");
        }
        finally {
            this.releaseConnection((HttpRequestBase)method);
        }
        String result = isSecure ? name + "=****" : name + "=" + value;
        return result;
    }

    public boolean verifyInventoryStatus(String envName, String appName, String componentName, String componentVersion, String inventoryStatus) throws IOException, JSONException {
        boolean result = false;
        boolean isID = false;
        try {
            UUID envUUID = UUID.fromString(envName);
            isID = true;
        }
        catch (IllegalArgumentException envUUID) {
            // empty catch block
        }
        String envID = isID ? envName : this.getEnvironmentUUID(envName, appName).toString();
        String uri = this.url + "/rest/inventory/desiredInventory/" + this.encodePath(envID);
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod((HttpRequestBase)method);
        String body = this.getBody(response);
        JSONArray responseJSON = new JSONArray(body);
        try {
            for (int i = 0; i < responseJSON.length(); ++i) {
                JSONObject statusObj;
                JSONObject versionObj;
                JSONObject obj = responseJSON.getJSONObject(i);
                JSONObject componentObj = obj.optJSONObject("component");
                if (componentObj == null || !componentObj.getString("name").equals(componentName) || (versionObj = obj.optJSONObject("version")) == null || !versionObj.getString("name").equals(componentVersion) || (statusObj = obj.optJSONObject("status")) == null || !statusObj.getString("name").equals(inventoryStatus)) continue;
                result = true;
                break;
            }
        }
        catch (JSONException e) {
            result = false;
        }
        return result;
    }

    public JSONObject getLatestEnvironmentInventoryByComponent(String envName, String appName, String compName) throws IOException, JSONException {
        UUID envId = this.getEnvironmentUUID(envName, appName);
        String uri = this.url + "/rest/inventory/versionByEnvironmentAndComponent/" + envId.toString() + "/" + this.encodePath(compName);
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod((HttpRequestBase)method);
        String body = this.getBody(response);
        JSONObject result = new JSONObject(body);
        return result;
    }

    public JSONArray deleteRedundantVersions(String envName, String appName, String compName, boolean deleteRedundant) throws IOException, JSONException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("deleteRedundant", String.valueOf(deleteRedundant));
        return this.deleteRedundantVersions(envName, appName, compName, queryParams);
    }

    public JSONArray deleteRedundantVersions(String envName, String appName, String compName, Map<String, String> queryParams) throws IOException, JSONException {
        if ("".equals(envName) || "".equals(appName) || "".equals(compName)) {
            throw new IOException("a required argument was not supplied");
        }
        UUID envId = this.getEnvironmentUUID(envName, appName);
        String uri = this.url + "/cli/environment/" + envId.toString() + "/redundantVersions/" + this.encodePath(compName) + this.getQueryParams(queryParams);
        HttpDelete method = new HttpDelete(uri);
        CloseableHttpResponse response = this.invokeMethod((HttpRequestBase)method);
        String body = this.getBody(response);
        return new JSONArray(body);
    }

    public JSONArray getOverlappingArtifacts(String envId, String cmpId, String resourceId, String versionId) throws IOException, JSONException {
        if (StringUtils.isEmpty((CharSequence)envId)) {
            throw new IOException("envId was not supplied");
        }
        if (StringUtils.isEmpty((CharSequence)cmpId)) {
            throw new IOException("cmpId was not supplied");
        }
        if (StringUtils.isEmpty((CharSequence)resourceId)) {
            throw new IOException("resourceId was not supplied");
        }
        if (StringUtils.isEmpty((CharSequence)versionId)) {
            throw new IOException("versionId was not supplied");
        }
        String uri = this.url + "/cli/environment/" + envId + "/" + cmpId + "/" + resourceId + "/overlappingArtifacts/" + versionId;
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod((HttpRequestBase)method);
        String body = this.getBody(response);
        JSONArray overlappingArtifactJsonArray = new JSONArray(body);
        return overlappingArtifactJsonArray;
    }

    public JSONArray deleteAllVersions(String envName, String appName, String compName, boolean deleteVersions) throws IOException, JSONException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("deleteVersions", String.valueOf(deleteVersions));
        return this.deleteAllVersions(envName, appName, compName, queryParams);
    }

    public JSONArray deleteAllVersions(String envName, String appName, String compName, Map<String, String> queryParams) throws IOException, JSONException {
        if ("".equals(envName) || "".equals(appName) || "".equals(compName)) {
            throw new IOException("a required argument was not supplied");
        }
        UUID envId = this.getEnvironmentUUID(envName, appName);
        String uri = this.url + "/cli/environment/" + envId.toString() + "/versions/" + this.encodePath(compName) + this.getQueryParams(queryParams);
        HttpDelete method = new HttpDelete(uri);
        CloseableHttpResponse response = this.invokeMethod((HttpRequestBase)method);
        String body = this.getBody(response);
        return new JSONArray(body);
    }

    private String getQueryParams(Map<String, String> queryParams) {
        if (queryParams.isEmpty()) {
            return "";
        }
        return "?" + queryParams.entrySet().stream().map(entry -> this.encodePath((String)entry.getKey()) + "=" + this.encodePath((String)entry.getValue())).collect(Collectors.joining("&"));
    }
}

