/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.httpcomponentsutil;

import com.urbancode.commons.httpcomponentsutil.ConnectionManagerCleaner;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConnectionCleaner
extends Thread {
    private static final Logger log = Logger.getLogger(ConnectionCleaner.class);
    private final ConnectionManagerCleaner<?> cleaner;

    ConnectionCleaner(ConnectionManagerCleaner<?> cleaner) {
        this.cleaner = cleaner;
        this.cleaner.getClass();
        this.setName("Idle connection cleaner [" + cleaner + "]");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        try {
            while (true) {
                Thread.sleep(10000L);
                try {
                    boolean needsFutureCleaning = this.cleaner.cleanConnections();
                    if (needsFutureCleaning) continue;
                    return;
                }
                catch (Exception e) {
                    log.error((Object)"Error in cleaner thread", (Throwable)e);
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Terminated by interrupt", (Throwable)e);
            }
            return;
        }
    }
}

