/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.filter;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class CachingFilter
implements Filter {
    private static Logger logger = Logger.getLogger(CachingFilter.class);
    private final long SECONDS_IN_MONTH = 2592000L;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        SimpleDateFormat df = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        Calendar cal = Calendar.getInstance();
        cal.add(2, 1);
        httpResponse.setHeader("Expires", df.format(cal.getTime()));
        httpResponse.setHeader("Cache-Control", "public, max-age=2592000, min-fresh=2592000");
        filterChain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) {
        logger.info((Object)"Filter initialized");
    }

    public void destroy() {
        logger.info((Object)"Filter destroyed");
    }
}

