/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.proxy;

import com.urbancode.commons.util.IO;
import com.urbancode.commons.web.proxy.ProxyResponse;
import com.urbancode.commons.web.proxy.ProxyResponseHeader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.input.TeeInputStream;

public class FileWritingProxyResponse
extends ProxyResponse {
    ProxyResponse response;
    File file = null;
    ObjectOutputStream tmpOut = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileWritingProxyResponse(ProxyResponse response, File file) throws IOException {
        boolean cleanup = true;
        try {
            int statusCode = response.getStatusCode();
            String statusReason = response.getStatusReason();
            List<ProxyResponseHeader> headers = response.getHeaders();
            InputStream entity = response.getEntity();
            this.response = response;
            this.file = file;
            FileOutputStream fos = new FileOutputStream(file);
            this.tmpOut = new ObjectOutputStream(fos);
            this.tmpOut.writeInt(statusCode);
            this.tmpOut.writeUTF(statusReason);
            this.tmpOut.writeObject(headers);
            this.setHeaders(headers);
            this.setStatusCode(statusCode);
            this.setStatusReason(statusReason);
            TeeInputStream teeEntity = new TeeInputStream(entity, (OutputStream)this.tmpOut);
            this.setEntity((InputStream)teeEntity);
            cleanup = false;
        }
        finally {
            if (cleanup) {
                IO.closeNoThrow((OutputStream)this.tmpOut);
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public void close() throws IOException {
        super.close();
        this.tmpOut.close();
        this.response.close();
    }
}

