/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.util;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;
import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringDecoder;
import org.apache.commons.codec.StringEncoder;
import org.apache.commons.lang3.Validate;

public class PercentCodec
implements StringEncoder,
StringDecoder,
BinaryEncoder,
BinaryDecoder {
    protected static final char ESCAPE_CHAR = '%';
    protected static final int HEX_RADIX = 16;
    protected static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    protected static final char[] RESERVED_CHARS = "!*'();:@&=+$,/?#[]".toCharArray();
    final CharsetDecoder decoder;
    final CharsetEncoder encoder;

    protected static boolean isUnreserved(char c) {
        if (c >= 'A' && c <= 'Z') {
            return true;
        }
        if (c >= 'a' && c <= 'z') {
            return true;
        }
        if (c >= '0' && c <= '9') {
            return true;
        }
        return c == '-' || c == '_' || c == '.' || c == '~';
    }

    protected static boolean isReserved(char c) {
        return Arrays.binarySearch(RESERVED_CHARS, c) >= 0;
    }

    public PercentCodec() {
        this(Charset.forName("UTF-8"));
    }

    public PercentCodec(String charsetName) {
        this(Charset.forName(charsetName));
    }

    public PercentCodec(Charset charset) {
        this(((Charset)Validate.notNull((Object)charset)).newEncoder(), charset.newDecoder());
    }

    public PercentCodec(CharsetEncoder encoder, CharsetDecoder decoder) {
        Validate.notNull((Object)decoder);
        Validate.notNull((Object)encoder);
        this.decoder = decoder;
        this.encoder = encoder;
    }

    public Object encode(Object value) throws EncoderException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.encode((String)value);
        }
        if (value instanceof byte[]) {
            return this.encode((byte[])value);
        }
        throw new EncoderException("Objects of type " + value.getClass().getName() + " cannot be encoded using PercentCodec");
    }

    public Object decode(Object value) throws DecoderException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.decode((String)value);
        }
        if (value instanceof byte[]) {
            return this.decode((byte[])value);
        }
        throw new DecoderException("Objects of type " + value.getClass().getName() + " cannot be decoded using PercentCodec");
    }

    public String decode(String arg0) throws DecoderException {
        StringBuilder sb = new StringBuilder();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        for (int i = 0; i < arg0.length(); ++i) {
            char c = arg0.charAt(i);
            if (c == '%') {
                int b;
                if (i + 3 > arg0.length()) {
                    throw new DecoderException("Invalid % sequence found %" + arg0.substring(i));
                }
                String hex = arg0.substring(i + 1, i + 3);
                try {
                    b = Integer.parseInt(hex, 16);
                }
                catch (NumberFormatException e) {
                    throw new DecoderException("Invalid % sequence found %" + hex, (Throwable)e);
                }
                bytes.write(b);
                i += 2;
                continue;
            }
            this.decodeToStringBuilder(bytes, sb);
            if (PercentCodec.isUnreserved(c)) {
                sb.append(c);
                continue;
            }
            if (PercentCodec.isReserved(c)) {
                sb.append(c);
                continue;
            }
            throw new DecoderException("Invalid character found " + c + " (x" + Integer.toHexString(c) + ")");
        }
        this.decodeToStringBuilder(bytes, sb);
        return sb.toString();
    }

    private void decodeToStringBuilder(ByteArrayOutputStream bytes, StringBuilder out) throws DecoderException {
        if (bytes.size() > 0) {
            CharBuffer cb;
            ByteBuffer bb = ByteBuffer.wrap(bytes.toByteArray());
            try {
                cb = this.decoder.decode(bb);
            }
            catch (CharacterCodingException e) {
                throw new DecoderException(e.toString(), (Throwable)e);
            }
            out.append(cb);
            bytes.reset();
        }
    }

    public String encode(String arg0) throws EncoderException {
        StringBuilder sb = new StringBuilder();
        int rangeStart = 0;
        boolean rangeDoEncode = false;
        for (int i = 0; i < arg0.length(); ++i) {
            boolean charDoEncode;
            char c = arg0.charAt(i);
            boolean bl = charDoEncode = !PercentCodec.isUnreserved(c);
            if (charDoEncode == rangeDoEncode) continue;
            this.copy(arg0, rangeStart, i, rangeDoEncode, sb);
            rangeStart = i;
            rangeDoEncode = charDoEncode;
        }
        this.copy(arg0, rangeStart, arg0.length(), rangeDoEncode, sb);
        return sb.toString();
    }

    private void copy(String str, int start, int end, boolean encode, StringBuilder out) throws EncoderException {
        String range = str.substring(start, end);
        if (!encode) {
            out.append(range);
        } else {
            ByteBuffer buffer;
            try {
                buffer = this.encoder.encode(CharBuffer.wrap(range));
            }
            catch (CharacterCodingException e) {
                throw new EncoderException(e.toString(), (Throwable)e);
            }
            while (buffer.hasRemaining()) {
                byte b = buffer.get();
                out.append('%');
                int hi = b >>> 4 & 0xF;
                out.append(HEX_ARRAY[hi]);
                out.append(HEX_ARRAY[b & 0xF]);
            }
        }
    }

    public byte[] encode(byte[] arg0) throws EncoderException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (byte b : arg0) {
            if (PercentCodec.isUnreserved((char)b)) {
                baos.write(b);
                continue;
            }
            baos.write(37);
            baos.write(HEX_ARRAY[b >>> 4 & 0xF]);
            baos.write(HEX_ARRAY[b & 0xF]);
        }
        return baos.toByteArray();
    }

    public byte[] decode(byte[] arg0) throws DecoderException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(arg0.length);
        for (int i = 0; i < arg0.length; ++i) {
            byte b = arg0[i];
            if (b == 37) {
                if (i + 3 > arg0.length) {
                    throw new DecoderException("Incomplete % sequence found");
                }
                byte hi = this.hexParse(arg0[++i]);
                byte lo = this.hexParse(arg0[++i]);
                b = (byte)(hi << 4 | lo);
            } else {
                char c = (char)b;
                if (!PercentCodec.isUnreserved(c) && !PercentCodec.isReserved(c)) {
                    throw new DecoderException("Invalid byte found " + c + " (x" + Integer.toHexString(c) + ")");
                }
            }
            baos.write(b);
        }
        return baos.toByteArray();
    }

    private byte hexParse(byte b) throws DecoderException {
        int i;
        if (b >= 48 && b <= 57) {
            i = b - 48;
        } else if (b >= 65 && b <= 70) {
            i = b - 65 + 10;
        } else if (b >= 97 && b <= 102) {
            i = b - 97 + 10;
        } else {
            throw new DecoderException("Invalid byte found x" + Integer.toHexString(b) + "");
        }
        return (byte)i;
    }

    static {
        Arrays.sort(RESERVED_CHARS);
    }
}

