/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ds.client;

import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder2;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.StringUtil;
import com.urbancode.commons.util.unix.Unix;
import com.urbancode.ds.client.AddVersionFilesCommand;
import com.urbancode.ds.client.ClientCommand;
import com.urbancode.ds.client.ClientConfiguration;
import com.urbancode.ds.client.ClientConfigurationDownloader;
import com.urbancode.ds.client.ClientConfigurationDownloaderFactory;
import com.urbancode.ds.client.CommandLineParser;
import com.urbancode.ds.client.DownloadVersionFilesCommand;
import com.urbancode.ds.client.HttpClientBuilderFactory;
import com.urbancode.ds.client.MissingRequiredParameterException;
import com.urbancode.ds.client.ParsedCommandLine;
import com.urbancode.ds.client.UnknownCommandException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONTokener;

public final class DeployCLI {
    static String log4j1ConfigFileProperty = "log4j.configuration";
    static String log4j2ConfigFileProperty = "log4j2.configurationFile";
    static boolean usingExplicitLog4jConfig;
    public static final String FLAG_HELP = "help";
    public static final String FLAG_VERBOSE = "verbose";
    public static final String FLAG_DEBUG = "debug";
    public static final String FLAG_DEBUG_HTTP = "debugHttp";
    public static final String OPTION_PROXY_HOST = "proxyHost";
    public static final String OPTION_PROXY_PORT = "proxyPort";
    public static final String OPTION_PROXY_USER = "proxyUser";
    public static final String OPTION_PROXY_PASS = "proxyPassword";
    public static final String OPTION_WEB_URL = "weburl";
    public static final String OPTION_AUTH_TOKEN = "authtoken";
    public static final String OPTION_USERNAME = "username";
    public static final String OPTION_PASSWORD = "password";
    public static final String OPTION_LOGGING_CONF = "loggingConf";
    public static final String OPTION_VERIFY_IDENTITY = "verifyServerIdentity";
    public static final String ENV_PROXY_HOST = "proxyHost";
    public static final String ENV_PROXY_PORT = "proxyPort";
    public static final String ENV_PROXY_USER = "proxyUser";
    public static final String ENV_PROXY_PASS = "proxyPassword";
    public static final String ENV_LOGGING_CONF = "loggingConf";
    public static final String ENV_WEB_URL = "DS_WEB_URL";
    public static final String ENV_AUTH_TOKEN = "DS_AUTH_TOKEN";
    public static final String ENV_USERNAME = "DS_USERNAME";
    public static final String ENV_PASSWORD = "DS_PASSWORD";
    public static final String ENV_VERIFY_IDENTITY = "UC_TLS_VERIFY_CERTS";
    public static final String PRODUCT_NAME_NORMAL = "UrbanCode Deploy";
    public static final String PRODUCT_NAME_SIMPLE = "ucd";
    public static final String CLI_SCRIPT_NAME = "udclient";
    public static final String AUTH_TOKEN_USERNAME = "PasswordIsAuthToken";

    public static void main(String[] args) {
        int exitCode;
        block21: {
            boolean verbose = true;
            try {
                Configuration conf;
                String log4j2Configuration;
                if (args.length == 0) {
                    System.out.println(new ClientConfiguration(null).toHelp());
                    exitCode = 0;
                    break block21;
                }
                CommandLineParser parser = new CommandLineParser();
                ParsedCommandLine parsedCommandLine = parser.parse(args, System.getenv());
                verbose = parsedCommandLine.isFlagSet(ClientConfiguration.FLAG_VERBOSE);
                if (!usingExplicitLog4jConfig && !StringUtil.isEmpty(log4j2Configuration = parsedCommandLine.getOptionValue("loggingConf", null, "loggingConf", null, false))) {
                    try {
                        File log4j2ConfigurationFile = new File(log4j2Configuration);
                        ConfigurationSource source = new ConfigurationSource((InputStream)new FileInputStream(log4j2ConfigurationFile), log4j2ConfigurationFile);
                        conf = ConfigurationFactory.getInstance().getConfiguration(null, source);
                        Configurator.reconfigure((Configuration)conf);
                        usingExplicitLog4jConfig = true;
                    }
                    catch (Exception log4j2ConfigurationFile) {
                        // empty catch block
                    }
                }
                if (!usingExplicitLog4jConfig) {
                    boolean debug = parsedCommandLine.isFlagSet(ClientConfiguration.FLAG_DEBUG);
                    boolean debugHttp = parsedCommandLine.isFlagSet(ClientConfiguration.FLAG_DEBUG_HTTP);
                    if (debug || debugHttp) {
                        Configurator.setLevel((String)"org.apache.http.headers", (Level)Level.WARN);
                    }
                    if (debug) {
                        verbose = true;
                        LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
                        conf = lc.getConfiguration();
                        Logger rootLogger = lc.getRootLogger();
                        ConsoleAppender origConsole = (ConsoleAppender)conf.getAppender("stdout");
                        if (origConsole != null) {
                            rootLogger.removeAppender((Appender)origConsole);
                        }
                        String debugPattern = "%r [%threadName] %level %logger %x - %message%n";
                        PatternLayout pl = PatternLayout.newBuilder().withConfiguration(conf).withPattern(debugPattern).build();
                        ConsoleAppender console = ((ConsoleAppender.Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder().setName("stdout-debug")).setTarget(ConsoleAppender.Target.SYSTEM_OUT).setLayout((Layout)pl)).build();
                        conf.addAppender((Appender)console);
                        rootLogger.addAppender((Appender)console);
                        Configurator.setRootLevel((Level)Level.DEBUG);
                        if (!debugHttp) {
                            Configurator.setLevel((String)"org.apache.http.wire", (Level)Level.WARN);
                        }
                    }
                    if (debugHttp) {
                        Configurator.setLevel((String)"org.apache.http.wire", (Level)Level.DEBUG);
                    }
                }
                String authToken = null;
                parsedCommandLine.getOptionValue(OPTION_WEB_URL, null, ENV_WEB_URL, null, true);
                String authTokenOption = parsedCommandLine.getOptionValue(OPTION_AUTH_TOKEN, null, ENV_AUTH_TOKEN, null, false);
                String username = parsedCommandLine.getOptionValue(OPTION_USERNAME, null, ENV_USERNAME, null, false);
                String password = parsedCommandLine.getOptionValue(OPTION_PASSWORD, null, ENV_PASSWORD, null, false);
                String verifyServerIdentity = parsedCommandLine.getOptionValue(OPTION_VERIFY_IDENTITY, null, ENV_VERIFY_IDENTITY, null, false);
                if (authTokenOption != null) {
                    File specAuthTokenFile = new File(authTokenOption);
                    authToken = specAuthTokenFile.isFile() ? IO.readTextFile(specAuthTokenFile) : authTokenOption;
                    username = AUTH_TOKEN_USERNAME;
                    JSONObject tokenJson = new JSONObject();
                    tokenJson.put("token", (Object)authToken);
                    password = tokenJson.toString();
                } else {
                    File userHome = new File(System.getProperty("user.home"));
                    File uDeploy = new File(userHome, ".ucd");
                    File authTokenFile = new File(uDeploy, "authToken");
                    if (authTokenFile.isFile()) {
                        authToken = IO.readTextFile(authTokenFile);
                    }
                    if (authToken != null) {
                        username = AUTH_TOKEN_USERNAME;
                        JSONObject tokenJson = new JSONObject();
                        while (authToken.endsWith("\n") || authToken.endsWith("\r")) {
                            authToken = authToken.substring(0, authToken.length() - 1);
                        }
                        tokenJson.put("token", (Object)authToken);
                        tokenJson.put("sysUser", (Object)System.getProperty("user.name"));
                        tokenJson.put("host", (Object)DeployCLI.getPrimaryIPv4());
                        password = tokenJson.toString();
                    }
                    if (username == null) {
                        System.out.println("Username not passed as command line property username or set in environment, DS_USERNAME");
                        username = System.console().readLine("Username : ", new Object[0]);
                    }
                    if (password == null) {
                        System.out.println("Password not passed as command line property password or set in environment, DS_PASSWORD");
                        password = String.valueOf(System.console().readPassword("Password : ", new Object[0]));
                    }
                }
                parsedCommandLine.setOptionValue(OPTION_USERNAME, username);
                parsedCommandLine.setOptionValue(OPTION_PASSWORD, password);
                parsedCommandLine.setOptionValue(OPTION_AUTH_TOKEN, null);
                parsedCommandLine.setOptionValue(OPTION_VERIFY_IDENTITY, verifyServerIdentity);
                DeployCLI main = new DeployCLI();
                exitCode = main.execute(parsedCommandLine, System.out, System.err, System.in);
            }
            catch (MissingRequiredParameterException e) {
                exitCode = 1;
                System.out.println(e.toString());
            }
            catch (Exception e) {
                exitCode = 1;
                if (verbose) {
                    e.printStackTrace();
                }
                String msg = (String)StringUtils.defaultIfEmpty((CharSequence)e.getMessage(), (CharSequence)e.toString());
                System.err.println(msg);
                if (verbose) break block21;
                System.out.println(" Retry with --verbose flag for more info.");
            }
        }
        System.exit(exitCode);
    }

    private static String[] getAllIPs() {
        ArrayList<String> ips = new ArrayList<String>();
        ArrayList<String> result = new ArrayList<String>();
        try {
            for (NetworkInterface interfaz : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                for (InetAddress inet : Collections.list(interfaz.getInetAddresses())) {
                    ips.add(inet.getHostAddress());
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        for (String ip : ips) {
            if (ip.startsWith("169.254") || ip.startsWith("fe80:")) continue;
            result.add(ip);
        }
        return result.toArray(new String[0]);
    }

    private static String[] getAllIPv4s() {
        String[] ips = DeployCLI.getAllIPs();
        ArrayList<String> result = new ArrayList<String>();
        for (String ip : ips) {
            if (ip.split("\\.").length != 4) continue;
            result.add(ip);
        }
        return result.toArray(new String[0]);
    }

    private static String getPrimaryIPv4() {
        String[] ips;
        String result = null;
        for (String ip : ips = DeployCLI.getAllIPv4s()) {
            if (ip.equals("localhost") || ip.equals("127.0.0.1")) continue;
            result = ip;
            break;
        }
        return result;
    }

    public int execute(ParsedCommandLine parsedCommandLine, PrintStream out, PrintStream err, InputStream in) throws Exception {
        int exitCode;
        block36: {
            String commandName = parsedCommandLine.getCommandName();
            ClientConfigurationDownloaderFactory clientConfigDownloaderFactory = ClientConfigurationDownloaderFactory.getInstance();
            ClientConfigurationDownloader configDownloader = clientConfigDownloaderFactory.createClientConfigurationDownloader();
            String baseURL = parsedCommandLine.getOptionValue(OPTION_WEB_URL, null, ENV_WEB_URL, null, true);
            HttpClientBuilder2 builder = HttpClientBuilderFactory.newBuilder(parsedCommandLine);
            CloseableHttpClient client = builder.buildClient();
            if ("logout".equals(commandName)) {
                try {
                    ClientConfiguration config = configDownloader.download((HttpClient)client, baseURL);
                    ClientCommand cmd = config.getCommandConfig(commandName);
                    if (parsedCommandLine.isPrintHelpAndExit()) {
                        exitCode = 0;
                        config.printHelp(out, parsedCommandLine.getCommandName());
                        break block36;
                    }
                    int responseCode = this.doLogout(parsedCommandLine, out, err, cmd, (HttpClient)client);
                    if (responseCode >= 200 && responseCode < 300) {
                        exitCode = 0;
                        break block36;
                    }
                    exitCode = 1;
                }
                catch (Exception e) {
                    this.deleteAuthTokenFile();
                    exitCode = 0;
                }
            } else {
                ClientConfiguration config;
                try {
                    config = configDownloader.download((HttpClient)client, baseURL);
                }
                catch (SecurityException e) {
                    boolean deletedAuthToken = this.deleteAuthTokenFile();
                    if (deletedAuthToken) {
                        out.println("The existing session has been closed. Please log in again to re-establish it.");
                    }
                    throw e;
                }
                if (parsedCommandLine.isPrintHelpAndExit()) {
                    exitCode = 0;
                    config.printHelp(out, parsedCommandLine.getCommandName());
                } else {
                    ClientCommand cmd = config.getCommandConfig(commandName);
                    if (cmd == null) {
                        throw new UnknownCommandException("Unknown command: " + commandName);
                    }
                    if (parsedCommandLine.isFlagSet(ClientConfiguration.FLAG_TEMPLATE)) {
                        if (cmd.getTemplate() != null) {
                            String templateText;
                            String prettyTemplate = templateText = cmd.getTemplate();
                            try {
                                JSONTokener json = new JSONTokener(templateText);
                                Object jsonToken = json.nextValue();
                                if (jsonToken instanceof JSONObject) {
                                    prettyTemplate = ((JSONObject)jsonToken).toString(2);
                                } else if (jsonToken instanceof JSONArray) {
                                    prettyTemplate = ((JSONArray)jsonToken).toString(2);
                                }
                            }
                            catch (JSONException json) {
                                // empty catch block
                            }
                            if (parsedCommandLine.getFileName() != null) {
                                FileOutputStream output = new FileOutputStream(parsedCommandLine.getFileName());
                                PrintStream fileOut = new PrintStream(output);
                                fileOut.println(prettyTemplate);
                                out.println("Template written to file " + parsedCommandLine.getFileName());
                                fileOut.flush();
                                fileOut.close();
                            } else {
                                out.println(prettyTemplate);
                            }
                        } else {
                            out.println("No template is available for the command " + cmd.getName());
                        }
                        exitCode = 0;
                    } else {
                        int responseCode = 0;
                        boolean standardCommand = true;
                        InputStream input = null;
                        File fileInput = null;
                        if (commandName.equals("login")) {
                            standardCommand = false;
                            responseCode = this.doLogin(parsedCommandLine, err, cmd, (HttpClient)client);
                        } else if (commandName.equals("addVersionFiles")) {
                            standardCommand = false;
                            responseCode = this.doAddVersionFiles(parsedCommandLine, out, err, cmd, (HttpClient)client);
                        } else if (commandName.equals("downloadVersionArtifacts")) {
                            standardCommand = false;
                            responseCode = this.doDownloadVersionFiles(parsedCommandLine, out, err, cmd, client);
                        } else if (parsedCommandLine.getFileName() != null) {
                            fileInput = new File(parsedCommandLine.getFileName());
                        } else if (parsedCommandLine.isReadFromInputStream()) {
                            input = in;
                        } else if (this.isSetPropertyCommand(commandName)) {
                            Map<String, Set<String>> options = parsedCommandLine.getOptMap();
                            JSONObject json = new JSONObject();
                            for (String option : options.keySet()) {
                                json.put(option, (Object)parsedCommandLine.getOptionValue(option, false));
                            }
                            input = new ByteArrayInputStream(json.toString().getBytes(Charset.forName("UTF-8")));
                        }
                        if (standardCommand) {
                            responseCode = cmd.execute(parsedCommandLine, out, err, input, fileInput);
                        }
                        exitCode = responseCode >= 200 && responseCode < 300 ? 0 : 1;
                    }
                }
            }
        }
        return exitCode;
    }

    private int doLogin(ParsedCommandLine parsedCommandLine, PrintStream err, ClientCommand cmd, HttpClient client) throws Exception {
        int responseCode = 0;
        JSONObject tokenJson = new JSONObject();
        tokenJson.put("sysUser", (Object)System.getProperty("user.name"));
        tokenJson.put("host", (Object)DeployCLI.getPrimaryIPv4());
        String inputString = tokenJson.toString();
        ByteArrayInputStream loginInput = new ByteArrayInputStream(inputString.getBytes());
        File userHome = new File(System.getProperty("user.home"));
        File uDeploy = new File(userHome, ".ucd");
        uDeploy.mkdirs();
        File authTokenFile = new File(uDeploy, "authToken");
        PrintStream pStream = new PrintStream(authTokenFile);
        responseCode = cmd.execute(parsedCommandLine, pStream, err, loginInput, null);
        pStream.close();
        Unix unix = new Unix();
        if (unix.isUnix()) {
            unix.chmod(authTokenFile, "go-wrx");
        }
        return responseCode;
    }

    private int doLogout(ParsedCommandLine parsedCommandLine, PrintStream out, PrintStream err, ClientCommand cmd, HttpClient client) throws FileNotFoundException, Exception {
        int result = 0;
        String username = parsedCommandLine.getOptionValue(OPTION_USERNAME, true);
        String password = parsedCommandLine.getOptionValue(OPTION_PASSWORD, true);
        if (username.equals(AUTH_TOKEN_USERNAME)) {
            ByteArrayInputStream logoutInput = new ByteArrayInputStream(password.getBytes());
            result = cmd.execute(parsedCommandLine, out, err, logoutInput, null);
        }
        this.deleteAuthTokenFile();
        return result;
    }

    private boolean deleteAuthTokenFile() {
        boolean result = false;
        File userHome = new File(System.getProperty("user.home"));
        File uDeploy = new File(userHome, ".ucd");
        File authTokenFile = new File(uDeploy, "authToken");
        if (authTokenFile.exists()) {
            result = authTokenFile.delete();
        }
        return result;
    }

    private int doAddVersionFiles(ParsedCommandLine parsedCommandLine, PrintStream out, PrintStream err, ClientCommand cmd, HttpClient client) throws Exception {
        File baseDirFile;
        boolean verbose;
        boolean saveExecuteBits;
        Set<String> excludes;
        Set<String> includes;
        String offset;
        String version;
        String component;
        String baseUrl;
        int result;
        block5: {
            result = 200;
            ClientConfiguration config = cmd.getConfig();
            baseUrl = parsedCommandLine.getOptionValue(config.getWebUrlOption());
            component = parsedCommandLine.getOptionValue("component", false);
            version = parsedCommandLine.getOptionValue("version", true);
            String baseDir = parsedCommandLine.getOptionValue("base", true);
            offset = parsedCommandLine.getOptionValue("offset", false);
            includes = parsedCommandLine.getOptionValues("include", false);
            excludes = parsedCommandLine.getOptionValues("exclude", false);
            saveExecuteBits = Boolean.valueOf(parsedCommandLine.getOptionValue("saveExecuteBits", false));
            verbose = parsedCommandLine.isFlagSet(ClientConfiguration.FLAG_VERBOSE);
            baseDirFile = new File(baseDir);
            if (!baseDirFile.isDirectory()) {
                throw new IllegalArgumentException("The given base directory is not a directory.");
            }
            if (includes == null) {
                includes = Collections.singleton("**/*");
            }
            if (excludes == null) {
                excludes = Collections.emptySet();
            }
            try {
                UUID.fromString(version);
            }
            catch (IllegalArgumentException e) {
                if (!StringUtil.isEmpty(component)) break block5;
                throw new MissingRequiredParameterException("Version name was given, but no component value was provided.");
            }
        }
        Charset charset = null;
        String[] extensions = new String[]{};
        AddVersionFilesCommand command = new AddVersionFilesCommand(baseUrl, client, component, version, baseDirFile, offset, includes.toArray(new String[includes.size()]), excludes.toArray(new String[excludes.size()]), saveExecuteBits, verbose, charset, extensions);
        command.execute();
        return result;
    }

    private int doDownloadVersionFiles(ParsedCommandLine parsedCommandLine, PrintStream out, PrintStream err, ClientCommand cmd, CloseableHttpClient client) throws Exception {
        String singleFilePath;
        String location;
        String version;
        String component;
        String baseUrl;
        int result;
        block2: {
            result = 200;
            ClientConfiguration config = cmd.getConfig();
            baseUrl = parsedCommandLine.getOptionValue(config.getWebUrlOption());
            component = parsedCommandLine.getOptionValue("component", false);
            version = parsedCommandLine.getOptionValue("version", true);
            location = parsedCommandLine.getOptionValue("location", false);
            singleFilePath = parsedCommandLine.getOptionValue("singleFilePath", false);
            try {
                UUID.fromString(version);
            }
            catch (IllegalArgumentException e) {
                if (!StringUtil.isEmpty(component)) break block2;
                throw new MissingRequiredParameterException("Version name was given, but no component value was provided.");
            }
        }
        DownloadVersionFilesCommand command = new DownloadVersionFilesCommand(baseUrl, (HttpClient)client, component, version, location, singleFilePath);
        command.execute();
        return result;
    }

    private boolean isSetPropertyCommand(String propertyName) {
        return propertyName.equals("setAgentProperty") || propertyName.equals("setApplicationProperty") || propertyName.equals("setComponentProperty") || propertyName.equals("setComponentEnvironmentProperty") || propertyName.equals("setEnvironmentProperty") || propertyName.equals("setResourceProperty") || propertyName.equals("setSystemProperty") || propertyName.equals("setVersionProperty");
    }

    static {
        boolean bl = usingExplicitLog4jConfig = System.getProperty(log4j1ConfigFileProperty) != null || System.getProperty(log4j2ConfigFileProperty) != null;
        if (!usingExplicitLog4jConfig) {
            ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
            builder.setStatusLevel(Level.WARN);
            builder.setConfigurationName("DefaultConfiguration");
            AppenderComponentBuilder appenderBuilder = (AppenderComponentBuilder)builder.newAppender("stdout", "CONSOLE").addAttribute("target", (Enum)ConsoleAppender.Target.SYSTEM_OUT);
            appenderBuilder.add((LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", "%level - %message%n"));
            RootLoggerComponentBuilder rootLogger = builder.newRootLogger(Level.WARN);
            rootLogger.add(builder.newAppenderRef("stdout"));
            builder.add(appenderBuilder);
            builder.add(rootLogger);
            Configurator.initialize((Configuration)((Configuration)builder.build()));
        }
    }
}

