/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.udeployversion;

import com.urbancode.airplugins.AirPluginTool;
import com.urbancode.ud.client.VersionClient;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Properties;
import java.util.UUID;
import java.util.function.IntConsumer;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

public class GetVersionStatusInfoStep {
    private final AirPluginTool apTool;
    private final VersionClientFactory clientFactory;
    private final PrintStream out;
    private final IntConsumer exit;

    public static void main(String[] args) {
        try {
            new GetVersionStatusInfoStep(args).run();
        }
        catch (Exception e) {
            System.out.printf("Error: %s%n", e.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    GetVersionStatusInfoStep(String[] args) {
        this(new AirPluginTool(args[0], args[1]), apTool -> {
            String udUrl = System.getenv("AH_WEB_URL");
            String udUser = apTool.getAuthTokenUsername();
            String udPass = apTool.getAuthToken();
            return new VersionClient(new URI(udUrl), udUser, udPass);
        }, System.out, System::exit);
    }

    GetVersionStatusInfoStep(AirPluginTool apTool, VersionClientFactory clientFactory, PrintStream out, IntConsumer exit) {
        this.apTool = apTool;
        this.apTool.getClass();
        this.clientFactory = clientFactory;
        this.clientFactory.getClass();
        this.out = out;
        this.out.getClass();
        this.exit = exit;
        this.exit.getClass();
    }

    public void run() throws Exception {
        boolean requiredStatusFound;
        VersionClient udRestClient = this.clientFactory.createClient(this.apTool);
        Properties props = this.apTool.getStepProperties();
        String versionName = props.getProperty("versionName", "").trim();
        String componentName = props.getProperty("componentName", "").trim();
        String requiredStatus = props.getProperty("requiredStatus", "").trim();
        this.out.printf("Getting id for Version %s of Component %s.%n", versionName, componentName);
        UUID versionId = udRestClient.getVersionId(componentName, versionName);
        JSONObject versionJson = udRestClient.getVersion(versionId.toString());
        JSONObject latestStatus = versionJson.optJSONObject("latestStatus");
        JSONArray statusArray = versionJson.getJSONArray("statuses");
        if (latestStatus != null) {
            this.apTool.setOutputProperty("versionLatestStatus", latestStatus.getString("name"));
        }
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < statusArray.length(); ++i) {
            JSONObject statusJson = statusArray.getJSONObject(i);
            ids.add(statusJson.getString("id"));
            names.add(statusJson.getString("name"));
        }
        this.apTool.setOutputProperty("versionStatuses", String.join((CharSequence)",", names));
        this.apTool.setOutputProperty("versionStatusIds", String.join((CharSequence)",", ids));
        boolean bl = requiredStatusFound = requiredStatus.isEmpty() || ids.contains(requiredStatus) || names.contains(requiredStatus);
        if (!requiredStatus.isEmpty()) {
            if (requiredStatusFound) {
                this.out.printf("Version has required status %s.%n", requiredStatus);
            } else {
                this.out.printf("Version did not have required status %s.%n", requiredStatus);
            }
            this.apTool.setOutputProperty("versionRequiredStatusFound", "" + requiredStatusFound);
        }
        this.apTool.storeOutputProperties();
        this.out.println("Version Status info added to output properties.");
        if (!requiredStatusFound) {
            this.exit.accept(1);
        }
    }

    @FunctionalInterface
    static interface VersionClientFactory {
        public VersionClient createClient(AirPluginTool var1) throws Exception;
    }
}

