<%--
- Licensed Materials - Property of IBM* and/or HCL**
- UrbanCode Deploy
- UrbanCode Build
- UrbanCode Release
- AnthillPro
- (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
- (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
-
- U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
- GSA ADP Schedule Contract with IBM Corp.
-
- * Trademark of International Business Machines
- ** Trademark of HCL Technologies Limited
--%>
<%@tag body-content="empty" %>

<%@attribute name="name" required="true"%>
<%@attribute name="value" required="true"%>
<%@attribute name="id" required="false"%>
<%@attribute name="size" required="false"    type="java.lang.Integer"%>
<%@attribute name="enabled" required="false" type="java.lang.Boolean"%>
<%@attribute name="confirm" required="false"%>
<%@attribute name="onPwdChange" required="false"%>
<%@attribute name="extraAttribs" required="false"%>
<%@attribute name="disableAutocomplete" required="false" type="java.lang.Boolean"%>


<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@taglib prefix="ah3" uri="http://www.urbancode.com/anthill3/tags" %>

<ah3:useConstants class="com.urbancode.supportal.web.WebConstants" />

<c:if test="${empty enabled || enbaled}">
    <c:set var="enabled" value="${true}"/>
</c:if>

<c:if test="${empty disableAutocomplete || disableAutocomplete}">
  <c:set var="disableAutocomplete" value='${true}'/>
</c:if>

<c:if test="${empty size}"><c:set var="size" value="20"/></c:if>
<c:if test="${empty id}"><c:set var="id" value="${name}"/></c:if>
<c:if test="${empty confirm}"><c:set var="confirm" value="${false}"/></c:if>

<c:if test="${!empty value}">
  <c:set var="value" value="${WebConstants.DUMMY_PASSWORD}"/><%-- must match WebConstants.DUMMY_PASSWORD --%>
</c:if>

<c:if test="${empty name}">
  <% if (true) { throw new IllegalArgumentException("NAME ATTRIBUTE IS EMPTY");} %>
</c:if>

<input type="password"
       name="${fn:escapeXml(name)}" 
       value="${fn:escapeXml(value)}" 
       size="${fn:escapeXml(size)}" 
       class="<c:if test="${!enabled}">inputdisabled</c:if>"
       <c:if test="${disableAutocomplete}">${' '}autocomplete="off"</c:if>
       <c:if test="${!enabled}">${' '}disabled="disabled"</c:if>
       <c:if test="${!empty id}">${' '}id="${fn:escapeXml(id)}"</c:if>
       <c:if test="${!empty onPwdChange}">${' '}onkeyup="if(this.value == '${value}') return; ${onPwdChange}; this.onkeyup=null; "</c:if> 
       <c:if test="${!empty extraAttribs}">${' '}${extraAttribs}</c:if>
       />
       
<c:if test="${confirm}">
  <div style="padding-top: 5px">
    <span style="font-size: smaller">confirm:<br/></span>
    <input ${autocompleteattrib} 
         class="input${disabled}" 
         type="password" 
         id="${fn:escapeXml(name)}Confirm" 
         name="${fn:escapeXml(name)}Confirm" 
         value="" 
         ${extraAttribs} 
         size="${fn:escapeXml(size)}" 
         ${disabled}>
   </div>
</c:if>


