<%--
- Licensed Materials - Property of IBM* and/or HCL**
- UrbanCode Deploy
- UrbanCode Build
- UrbanCode Release
- AnthillPro
- (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
- (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
-
- U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
- GSA ADP Schedule Contract with IBM Corp.
-
- * Trademark of International Business Machines
- ** Trademark of HCL Technologies Limited
--%>
<%@tag body-content="empty" %>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@taglib prefix="ucf" tagdir="/WEB-INF/tags/form" %>

<%@attribute name="id" required="true" type="java.lang.String"%>
<%@attribute name="name" required="true" type="java.lang.String"%>
<%@attribute name="value" required="true" type="java.lang.String"%>
<%@attribute name="cols" required="true" type="java.lang.Integer"%>
<%@attribute name="rows" required="true" type="java.lang.Integer"%>
<%@attribute name="language" required="false" type="java.lang.String"%>
<%@attribute name="enabled" required="false" type="java.lang.Boolean"%>
<%@attribute name="autocomplete" required="false" type="java.lang.Boolean"%>
<%@attribute name="linenumbers" required="false" type="java.lang.Boolean"%>

<c:choose>
    <c:when test="${empty enabled || enabled}">
        
        <c:choose>
            <c:when test="${autocomplete == null || !autocomplete}">
                <c:set var="autocompleteClass" value="autocomplete-off"/>
            </c:when>
            <c:otherwise>
                <c:set var="autocompleteClass" value="autocomplete-on"/>
            </c:otherwise>
        </c:choose>
            
        <c:choose>
            <c:when test="${linenumbers == null || linenumbers}">
                <c:set var="linenumbersClass" value="linenumbers-on"/>
            </c:when>
            <c:otherwise>
                <c:set var="linenumbersClass" value="linenumbers-off"/>                
            </c:otherwise>
        </c:choose>
        
        <c:choose>
            <c:when test="${language == 'javascript'}">
                <c:set var="language" value=" javascript"/>
            </c:when>
            <c:otherwise>
                <c:set var="language" value=" java"/>
            </c:otherwise>         
        </c:choose>
            
            <!-- altered -->
            
        <input type="hidden" id="${fn:escapeXml(id)}" name="${fn:escapeXml(name)}" value="${fn:escapeXml(value)}"/>
        <textarea 
            id="${fn:escapeXml(id)}_scriptarea" 
            name="${fn:escapeXml(name)}_scriptarea"
            rows="${fn:escapeXml(rows)}"
            cols="${fn:escapeXml(cols)}"
            class="${linenumbersClass}${' '}${autocompleteClass}${' '}${language}"
            >${fn:escapeXml(value)}</textarea>

       <script type="text/javascript">
            <%-- This method will be called on the forms onsubmit event and takes
            the edited code from the <textarea> and associates it with the hidden
            element directly above it.  Codepress will wipe out the textarea on
            page reload so it won't be submitted with the form.
            --%>
            var onSubmitHandlerFor${id} = function () {
                var scriptElement = YAHOO.util.Dom.get( "${fn:escapeXml(id)}" );                
                try {
                    scriptElement.setAttribute( "value", ${fn:escapeXml(id)}_scriptarea.getCode() );
                } catch( e ) {
                    /* Safari & opera don't work with codepress, we will just grab the scriptarea data
                     * and allow it to be submitted. */
                    var codeElement = YAHOO.util.Dom.get( "${fn:escapeXml(id)}_scriptarea" );
                    scriptElement.setAttribute( "value", codeElement.value );
                }
            }
            
            <%-- Add our codepress class if we are using mozilla. --%>
            if (YAHOO.env.ua.gecko != 0) {
                var scriptarea = YAHOO.util.Dom.get( "${fn:escapeXml(id)}_scriptarea" );
                YAHOO.util.Dom.addClass( scriptarea, "codepress" );
            }
            
            <%-- Attach our onsubmit handler to the form. --%>
            YAHOO.util.Event.addListener( YAHOO.util.Dom.get("${fn:escapeXml(id)}").form, "submit", onSubmitHandlerFor${id} );
        </script>        
            
    </c:when>
    <c:otherwise>
        <%-- If we are in disabled mode, just use the standard textarea tag. --%>
        <ucf:textarea name="${name}" value="${value}" cols="${cols}" rows="${rows}" enabled="${false}"/>        
    </c:otherwise>
</c:choose>