<%--
- Licensed Materials - Property of IBM* and/or HCL**
- UrbanCode Deploy
- UrbanCode Build
- UrbanCode Release
- AnthillPro
- (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
- (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
-
- U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
- GSA ADP Schedule Contract with IBM Corp.
-
- * Trademark of International Business Machines
- ** Trademark of HCL Technologies Limited
--%>
<%@tag body-content="empty" %>

<%@attribute name="name" required="true"%>
<%@attribute name="value" required="true"%>
<%@attribute name="id" required="false"%>
<%@attribute name="size" required="false" type="java.lang.Integer"%>
<%@attribute name="enabled" required="false" type="java.lang.Boolean"%>
<%@attribute name="onChange" required="false"%>
<%@attribute name="onBlur" required="false"%>
<%@attribute name="maxLength" required="false" type="java.lang.Integer"%>

<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>

<c:if test="${empty size}">
  <c:set var="size" value="30"/>
</c:if>

<c:set var="enabled" value="${empty enabled || enabled}"/>

<c:if test="${empty name}">
  <% if (true) throw new IllegalArgumentException("NAME ATTRIBUTE IS EMPTY"); %>
</c:if>

<input type="text"
    <c:if test="${!empty onChange}">onchange="${onChange}"${' '}</c:if> 
    <c:if test="${!empty onBlur}">onblur="${onBlur}"${' '}</c:if>
    <c:if test="${!empty id}">id="${fn:escapeXml(id)}"${' '}</c:if>
    name="${fn:escapeXml(name)}" 
    value="${fn:escapeXml(value)}" 
    size="${fn:escapeXml(size)}" 
    class="<c:if test="${!enabled}">inputdisabled</c:if>"<%-- add any extra custom classes here: space-separated attribute --%>
    <c:if test="${!enabled}">${' '}disabled="disabled"</c:if>
    <c:if test="${! empty maxLength}">maxlength="${maxLength}"</c:if>
  />

