<%--
- Licensed Materials - Property of IBM* and/or HCL**
- UrbanCode Deploy
- UrbanCode Build
- UrbanCode Release
- AnthillPro
- (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
- (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
-
- U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
- GSA ADP Schedule Contract with IBM Corp.
-
- * Trademark of International Business Machines
- ** Trademark of HCL Technologies Limited
--%>
<%@tag body-content="empty" %>

<%@attribute name="name" required="true"%>
<%@attribute name="value" required="true"%>
<%@attribute name="enabled" required="false" type="java.lang.Boolean"%>
<%@attribute name="cols" required="false" type="java.lang.Integer"%>
<%@attribute name="rows" required="false" type="java.lang.Integer"%>
<%@attribute name="id" required="false" type="java.lang.String"%>

<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>

<c:choose>
  <c:when test="${enabled == null || enabled}">
    <c:set var="disabled" value=""/>
  </c:when>

  <c:otherwise>
    <c:set var="disabled" value="disabled"/>
  </c:otherwise>
</c:choose>

<c:if test="${empty cols}">
    <c:set var="cols" value="60"/>
</c:if>

<c:if test="${empty rows}">
    <c:set var="rows" value="5"/>
</c:if>

<c:choose>
  <c:when test="${empty name}">
    <span style="font-weight: bold; color:red">ERROR: NAME ATTRIBUTE IS EMPTY</b>
  </c:when>
  
  <c:otherwise>
    <textarea <c:if test="${!empty id}">id="${id}"</c:if> class="input${disabled}" name="${fn:escapeXml(name)}" cols="${fn:escapeXml(cols)}" rows="${fn:escapeXml(rows)}" ${disabled}>${fn:escapeXml(value)}</textarea>
  </c:otherwise>
</c:choose>

