#!/usr/bin/env groovy
/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2011, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.XTrustProvider
import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.HttpRequest;

final def workDir = new File('.').canonicalFile
final def props = new Properties();
final def inputPropsFile = new File(args[0]);
final def inputPropsStream = null;

def ant = new AntBuilder()


def flip = { file ->
    File tempFile = File.createTempFile("temp", "file");
    file.eachLine { line ->
       tempFile.append(line);
       tempFile.append(System.getProperty("line.separator"));
    }
    ant.copy(file:tempFile.getAbsolutePath(), tofile:file.getAbsolutePath(), overwrite:true);
    tempFile.delete();
}

try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}

final def serverUrl = props['serverUrl'];
final def requestId = props['requestId'];
final def name = props['name'];

final def proxyHost = System.env['PROXY_HOST'] ? System.env['PROXY_HOST'] : null
final def proxyPort = System.env['PROXY_PORT'] ? Integer.valueOf(System.env['PROXY_PORT']) : null

def propFile = File.createTempFile("prop.",".properties", workDir);
def propFileName = propFile.getName();
propFile.delete();
def includes = name;
def excludes = "";
def propertyPrefix ="";

def envPropValues = props['envPropValues'];
def startDelimiter = '@';
def endDelimiter = '@';

final def baseDirectory = new File('.')

def finalGetUrl = serverUrl + "rest/deploy/configTemplate/byRequest/${requestId}/${name}";

if (baseDirectory.isFile()) {
    throw new IllegalArgumentException("Base directory ${baseDirectory} is a file!")
}
else if (!baseDirectory.isDirectory()) {
    throw new IllegalArgumentException("Base directory ${baseDirectory} does not exist!");
}

File finalDest = new File(baseDirectory, name);
if (finalDest.exists() && !finalDest.isFile()) {
    throw new IllegalArgumentException("File name ${name} already exists in ${baseDirectory} but is not a file!");
}
//
// Download the files
//

XTrustProvider.install()

println "Downloading file ${name} to ${baseDirectory}"
println "From Url ${finalGetUrl}"

HttpClientBuilder builder = new HttpClientBuilder();
String verifyServerIdentityString = System.getenv().get("UC_TLS_VERIFY_CERTS");
Boolean trustAllCerts = Boolean.valueOf(verifyServerIdentityString);
builder.setTrustAllCerts(!trustAllCerts);
builder.setPreemptiveAuthentication(true);
if (proxyHost) {
    builder.setProxyHost(proxyHost);
    builder.setProxyPort(proxyPort);
}
DefaultHttpClient client = builder.buildClient();
HttpGet fileMethod = new HttpGet(finalGetUrl);
HttpResponse response = client.execute(fileMethod);
def code = response.getStatusLine().getStatusCode();
if (code < 200 || code >= 300) { 
    throw new Exception("Got a non-successful error code from get method : ${code}");
}

if (finalDest.isFile()) {
    println "File already exists ... Replacing ...";
    finalDest.delete();
}

finalDest << response.getEntity().getContent();

println "Download complete"



try {

    def Properties properties = new Properties()
    def outStream  = new FileOutputStream(propFile)
    if(envPropValues) {
       if (propertyPrefix) {
            println "Looking for properties starting with $propertyPrefix"
        }
        //this is jeffs magic regex to split on ,'s preceded by even # of \ including 0
        envPropValues.split("(?<=(^|[^\\\\])(\\\\{2}){0,8}),").each { prop ->
            //split out the name
            def parts = prop.split("(?<=(^|[^\\\\])(\\\\{2}){0,8})=",2);
            def propName = parts[0];
            def propValue = parts.size() == 2 ? parts[1] : "";
            //replace \, with just , and then \\ with \
            propName = propName.replace("\\=", "=").replace("\\,", ",").replace("\\\\", "\\")
            propValue = propValue.replace("\\=", "=").replace("\\,", ",").replace("\\\\", "\\")

            if ((!propertyPrefix || propName.startsWith(propertyPrefix))) {
                properties.setProperty(startDelimiter + propName + endDelimiter, propValue)
                println 'added: ' + startDelimiter + propName + endDelimiter + ':' + propValue
            }
        }
    }
    properties.store(outStream, 'Auto generated property file')
    outStream.close()

    if (properties.size() > 0) {
        println "Replacing tokens..."
        if (excludes) {
            ant.replace(
                    dir:".",
                    summary: 'true',
                    replacefilterfile: propFileName,
                    includes: includes,
                    excludes: excludes,
                    defaultexcludes: 'no')

        }   
        else {
            ant.replace(
                    dir:".",
                    summary: 'true',
                    replacefilterfile: propFileName,
                    includes: includes,
                    defaultexcludes: 'no')
        }   
        println "Token replacement complete"
    }   
    else {
        println 'No properties found to replace tokens for. No token replacement needed.'
    }  
    flip(finalDest);
}
catch (Exception e) {
    println "Error replacing tokens!"
    e.printStackTrace()
    System.exit(1)
}
finally {
    if (propFile != null) {
        propFile.delete()
    }
}

