/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.httpcomponentsutil;

import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.log4j.Logger;

class ConnectionCleaner
extends Thread {
    private static final Logger log = Logger.getLogger(ConnectionCleaner.class);
    private final WeakReference<CloseableHttpClient> client;
    private final long idleConnectionTimeout;

    ConnectionCleaner(CloseableHttpClient client, long idleConnectionTimeout) {
        if (idleConnectionTimeout < 0L) {
            idleConnectionTimeout = 30000L;
        }
        this.client = new WeakReference<CloseableHttpClient>(client);
        this.idleConnectionTimeout = idleConnectionTimeout;
        this.setName("Idle connection cleaner [" + client + "]");
        this.setDaemon(true);
    }

    public void run() {
        try {
            while (true) {
                ClientConnectionManager mgr;
                Thread.sleep(10000L);
                try {
                    CloseableHttpClient client = (CloseableHttpClient)this.client.get();
                    if (client == null) {
                        return;
                    }
                    mgr = client.getConnectionManager();
                    if (mgr != null) {
                        mgr.closeIdleConnections(this.idleConnectionTimeout, TimeUnit.MILLISECONDS);
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Error in cleaner thread", (Throwable)e);
                }
                mgr = null;
                Object var2_3 = null;
            }
        }
        catch (InterruptedException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Terminated by interrupted", (Throwable)e);
            }
            return;
        }
    }
}

