/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.httpcomponentsutil;

import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ConnectionManagerCleaner<T>
extends WeakReference<T> {
    private final long idleTime;
    private final TimeUnit timeUnit;

    protected ConnectionManagerCleaner(T manager, long idleTime, TimeUnit timeUnit) {
        super(manager);
        if (idleTime < 0L) {
            idleTime = 30000L;
        }
        this.idleTime = idleTime;
        this.timeUnit = timeUnit;
        ((Object)((Object)this.timeUnit)).getClass();
    }

    public boolean cleanConnections() {
        Object manager = this.get();
        if (manager == null) {
            return false;
        }
        this.doCleaning(manager);
        return true;
    }

    protected abstract void doCleaning(T var1);

    protected long getIdleTime() {
        return this.idleTime;
    }

    protected TimeUnit getTimeUnit() {
        return this.timeUnit;
    }
}

