/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* (c) Copyright IBM Corporation 2013, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
package com.urbancode.air.plugin.webutilities

/**
 * [WSP] *CHAR [WSP] ':' / '=' [WSP] *CHAR [WSP] parsed onto blank or given hashmap
 *
 * @param   textArea     Accepts any [WSP] *CHAR [WSP] ':' / '=' [WSP] *CHAR [WSP]
 * @param   happy        Accepts any linked hashmap
 * @return               A linked hashmap built ontop of the linked hashmap happy from parsing the textAeaasss
 */
def static textAreaToHashMap (textArea, def happy = [:]) {
    try {
        textArea.eachLine { text ->
            def mappy = text.split('=|:', 2)
            if (mappy[0].trim()) {
                happy[mappy[0].trim().toLowerCase()] = mappy[1].trim()
            }
        }
        return happy
    } catch (NullPointerException e) {
        throw e
    }
}
