/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* (c) Copyright IBM Corporation 2013, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
package com.urbancode.air.plugin.webutilities

import org.apache.http.client.methods.HttpUriRequest
import org.apache.http.client.config.RequestConfig
import org.apache.http.client.methods.RequestBuilder
import org.apache.http.entity.StringEntity
import org.apache.http.entity.FileEntity

/**
 * Creates an HTTP request object which represent a HTTP request message.
 *
 * @param   url         Accepts any URL as defined in RFC 2396 and RFC 2732.
 * @param   headers     Accepts any list.
 * @param   method      Accepts any String.
 * @param   body        Accepts any String.
 * @return              A HttpRequestEntity
 */
public static HttpUriRequest createHTTPRequest (String url, Map headers, String method, String body, int timeout) {

    RequestBuilder httpRequestEntity = new RequestBuilder().create(method)
    httpRequestEntity.setUri(url)
    for (header in headers) {
        String key = header.getKey().toString()
        String value = header.getValue().toString()
        httpRequestEntity.setHeader(key, value)
    }
    httpRequestEntity.setEntity(new StringEntity(body))
	
	//per request timeouts in milliseconds
	RequestConfig requestConfig = RequestConfig
			.custom()
			.setConnectionRequestTimeout(timeout * 60 * 1000) // how long a client should wait for a connection from the connection pool
			.setConnectTimeout(timeout * 60 * 1000) // how long the HttpClient should wait when trying to connect a server
			.setSocketTimeout(timeout * 60 * 1000) // the maximum interval between consequent network packets
			.build();
	httpRequestEntity.setConfig(requestConfig)

    return httpRequestEntity.build()
}

/**
 * Creates an HTTP request object which represent a HTTP request with a zip file in the content
 *
 * @param   url         Accepts any URL as defined in RFC 2396 and RFC 2732.
 * @param   headers     Accepts any list.
 * @param   method      Accepts any String.
 * @param   file              Accepts a File
 * @return              A HttpRequestEntity
 */
public static HttpUriRequest createHTTPRequestForZip (String url, Map headers, String method, File file, int timeout) {

    RequestBuilder httpRequestEntity = new RequestBuilder().create(method)
    httpRequestEntity.setUri(url)
    for (header in headers) {
        String key = header.getKey().toString()
        String value = header.getValue().toString()
        httpRequestEntity.setHeader(key, value)
    }
    httpRequestEntity.setEntity(new FileEntity(file,"application/zip"))
	
	//per request timeouts in milliseconds
	RequestConfig requestConfig = RequestConfig
			.custom()
			.setConnectionRequestTimeout(timeout * 60 * 1000) // how long a client should wait for a connection from the connection poo
			.setConnectTimeout(timeout * 60 * 1000) // how long the HttpClient should wait when trying to connect a server
			.setSocketTimeout(timeout * 60 * 1000) // the maximum interval between consequent network packets
			.build();
	httpRequestEntity.setConfig(requestConfig)

    return httpRequestEntity.build()
}
